/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.core.object.component.LayoutComponent;
import discord4j.core.object.component.MessageComponent;
import discord4j.core.object.entity.Attachment;
import discord4j.core.spec.EmbedCreateSpec;
import discord4j.core.spec.EmbedCreateSpecGenerator;
import discord4j.core.spec.InternalSpecUtils;
import discord4j.core.spec.MessageCreateFields;
import discord4j.core.spec.Spec;
import discord4j.discordjson.json.ImmutableWebhookMessageEditRequest;
import discord4j.discordjson.json.WebhookMessageEditRequest;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.AllowedMentions;
import discord4j.rest.util.MultipartRequest;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.immutables.value.Value;

@Value.Immutable(singleton=true)
interface InteractionReplyEditSpecGenerator
extends Spec<MultipartRequest<WebhookMessageEditRequest>> {
    public Possible<Optional<String>> content();

    public Possible<Optional<List<EmbedCreateSpec>>> embeds();

    @Value.Default
    default public List<MessageCreateFields.File> files() {
        return Collections.emptyList();
    }

    @Value.Default
    default public List<MessageCreateFields.FileSpoiler> fileSpoilers() {
        return Collections.emptyList();
    }

    public Possible<Optional<AllowedMentions>> allowedMentions();

    public Possible<Optional<List<LayoutComponent>>> components();

    public Possible<Optional<List<Attachment>>> attachments();

    @Override
    default public MultipartRequest<WebhookMessageEditRequest> asRequest() {
        ImmutableWebhookMessageEditRequest json = WebhookMessageEditRequest.builder().content(this.content()).embeds(InternalSpecUtils.mapPossibleOptional(this.embeds(), embeds -> embeds.stream().map(EmbedCreateSpecGenerator::asRequest).collect(Collectors.toList()))).allowedMentions(InternalSpecUtils.mapPossibleOptional(this.allowedMentions(), AllowedMentions::toData)).components(InternalSpecUtils.mapPossible(this.components(), components -> components.map(list -> list.stream().map(MessageComponent::getData).collect(Collectors.toList())).orElse(Collections.emptyList()))).attachments(InternalSpecUtils.mapPossibleOptional(this.attachments(), attachments -> attachments.stream().map(Attachment::getData).collect(Collectors.toList()))).build();
        return MultipartRequest.ofRequestAndFiles(json, Stream.concat(this.files().stream(), this.fileSpoilers().stream()).map(MessageCreateFields.File::asRequest).collect(Collectors.toList()));
    }
}

