/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import discord4j.common.util.Snowflake;
import discord4j.core.object.component.LayoutComponent;
import discord4j.core.spec.EmbedCreateSpec;
import discord4j.core.spec.ImmutableMessageCreateFields;
import discord4j.core.spec.MessageCreateFields;
import discord4j.core.spec.MessageCreateSpecGenerator;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.AllowedMentions;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;

@Generated(from="MessageCreateSpecGenerator", generator="Immutables")
public final class MessageCreateSpec
implements MessageCreateSpecGenerator {
    private final String content_value;
    private final boolean content_absent;
    private final String nonce_value;
    private final boolean nonce_absent;
    private final Boolean tts_value;
    private final boolean tts_absent;
    private final List<EmbedCreateSpec> embeds_value;
    private final boolean embeds_absent;
    private final List<MessageCreateFields.File> files;
    private final List<MessageCreateFields.FileSpoiler> fileSpoilers;
    private final AllowedMentions allowedMentions_value;
    private final boolean allowedMentions_absent;
    private final Snowflake messageReference_value;
    private final boolean messageReference_absent;
    private final List<LayoutComponent> components_value;
    private final boolean components_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final MessageCreateSpec INSTANCE = MessageCreateSpec.validate(new MessageCreateSpec());

    private MessageCreateSpec() {
        Possible content$impl = Possible.absent();
        Possible nonce$impl = Possible.absent();
        Possible tts$impl = Possible.absent();
        Possible embeds$impl = Possible.absent();
        Possible allowedMentions$impl = Possible.absent();
        Possible messageReference$impl = Possible.absent();
        Possible components$impl = Possible.absent();
        this.content_value = content$impl.toOptional().orElse(null);
        this.content_absent = content$impl.isAbsent();
        this.nonce_value = nonce$impl.toOptional().orElse(null);
        this.nonce_absent = nonce$impl.isAbsent();
        this.tts_value = tts$impl.toOptional().orElse(null);
        this.tts_absent = tts$impl.isAbsent();
        this.embeds_value = embeds$impl.toOptional().orElse(null);
        this.embeds_absent = embeds$impl.isAbsent();
        this.allowedMentions_value = allowedMentions$impl.toOptional().orElse(null);
        this.allowedMentions_absent = allowedMentions$impl.isAbsent();
        this.messageReference_value = messageReference$impl.toOptional().orElse(null);
        this.messageReference_absent = messageReference$impl.isAbsent();
        this.components_value = components$impl.toOptional().orElse(null);
        this.components_absent = components$impl.isAbsent();
        this.files = this.initShim.files();
        this.fileSpoilers = this.initShim.fileSpoilers();
        this.initShim = null;
    }

    private MessageCreateSpec(Builder builder) {
        Possible content$impl = builder.content_build();
        Possible nonce$impl = builder.nonce_build();
        Possible tts$impl = builder.tts_build();
        Possible embeds$impl = builder.embeds_build();
        Possible allowedMentions$impl = builder.allowedMentions_build();
        Possible messageReference$impl = builder.messageReference_build();
        Possible components$impl = builder.components_build();
        if (builder.filesIsSet()) {
            this.initShim.files(MessageCreateSpec.createUnmodifiableList(true, builder.files));
        }
        if (builder.fileSpoilersIsSet()) {
            this.initShim.fileSpoilers(MessageCreateSpec.createUnmodifiableList(true, builder.fileSpoilers));
        }
        this.content_value = content$impl.toOptional().orElse(null);
        this.content_absent = content$impl.isAbsent();
        this.nonce_value = nonce$impl.toOptional().orElse(null);
        this.nonce_absent = nonce$impl.isAbsent();
        this.tts_value = tts$impl.toOptional().orElse(null);
        this.tts_absent = tts$impl.isAbsent();
        this.embeds_value = embeds$impl.toOptional().orElse(null);
        this.embeds_absent = embeds$impl.isAbsent();
        this.allowedMentions_value = allowedMentions$impl.toOptional().orElse(null);
        this.allowedMentions_absent = allowedMentions$impl.isAbsent();
        this.messageReference_value = messageReference$impl.toOptional().orElse(null);
        this.messageReference_absent = messageReference$impl.isAbsent();
        this.components_value = components$impl.toOptional().orElse(null);
        this.components_absent = components$impl.isAbsent();
        this.files = this.initShim.files();
        this.fileSpoilers = this.initShim.fileSpoilers();
        this.initShim = null;
    }

    private MessageCreateSpec(Possible<String> content, Possible<String> nonce, Possible<Boolean> tts, Possible<List<EmbedCreateSpec>> embeds, List<MessageCreateFields.File> files, List<MessageCreateFields.FileSpoiler> fileSpoilers, Possible<AllowedMentions> allowedMentions, Possible<Snowflake> messageReference, Possible<List<LayoutComponent>> components) {
        Possible<String> content$impl = content;
        Possible<String> nonce$impl = nonce;
        Possible<Boolean> tts$impl = tts;
        Possible<List<EmbedCreateSpec>> embeds$impl = embeds;
        this.initShim.files(files);
        this.initShim.fileSpoilers(fileSpoilers);
        Possible<AllowedMentions> allowedMentions$impl = allowedMentions;
        Possible<Snowflake> messageReference$impl = messageReference;
        Possible<List<LayoutComponent>> components$impl = components;
        this.content_value = content$impl.toOptional().orElse(null);
        this.content_absent = content$impl.isAbsent();
        this.nonce_value = nonce$impl.toOptional().orElse(null);
        this.nonce_absent = nonce$impl.isAbsent();
        this.tts_value = tts$impl.toOptional().orElse(null);
        this.tts_absent = tts$impl.isAbsent();
        this.embeds_value = embeds$impl.toOptional().orElse(null);
        this.embeds_absent = embeds$impl.isAbsent();
        this.allowedMentions_value = allowedMentions$impl.toOptional().orElse(null);
        this.allowedMentions_absent = allowedMentions$impl.isAbsent();
        this.messageReference_value = messageReference$impl.toOptional().orElse(null);
        this.messageReference_absent = messageReference$impl.isAbsent();
        this.components_value = components$impl.toOptional().orElse(null);
        this.components_absent = components$impl.isAbsent();
        this.files = this.initShim.files();
        this.fileSpoilers = this.initShim.fileSpoilers();
        this.initShim = null;
    }

    private List<MessageCreateFields.File> filesInitialize() {
        return MessageCreateSpecGenerator.super.files();
    }

    private List<MessageCreateFields.FileSpoiler> fileSpoilersInitialize() {
        return MessageCreateSpecGenerator.super.fileSpoilers();
    }

    @Override
    public Possible<String> content() {
        return this.content_absent ? Possible.absent() : Possible.of(this.content_value);
    }

    @Override
    public Possible<String> nonce() {
        return this.nonce_absent ? Possible.absent() : Possible.of(this.nonce_value);
    }

    @Override
    public Possible<Boolean> tts() {
        return this.tts_absent ? Possible.absent() : Possible.of(this.tts_value);
    }

    @Override
    public Possible<List<EmbedCreateSpec>> embeds() {
        return this.embeds_absent ? Possible.absent() : Possible.of(this.embeds_value);
    }

    @Override
    public List<MessageCreateFields.File> files() {
        InitShim shim = this.initShim;
        return shim != null ? shim.files() : this.files;
    }

    @Override
    public List<MessageCreateFields.FileSpoiler> fileSpoilers() {
        InitShim shim = this.initShim;
        return shim != null ? shim.fileSpoilers() : this.fileSpoilers;
    }

    @Override
    public Possible<AllowedMentions> allowedMentions() {
        return this.allowedMentions_absent ? Possible.absent() : Possible.of(this.allowedMentions_value);
    }

    @Override
    public Possible<Snowflake> messageReference() {
        return this.messageReference_absent ? Possible.absent() : Possible.of(this.messageReference_value);
    }

    @Override
    public Possible<List<LayoutComponent>> components() {
        return this.components_absent ? Possible.absent() : Possible.of(this.components_value);
    }

    public MessageCreateSpec withContent(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return MessageCreateSpec.validate(new MessageCreateSpec(newValue, this.nonce(), this.tts(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.messageReference(), this.components()));
    }

    public MessageCreateSpec withContent(String value) {
        Possible<String> newValue = Possible.of(value);
        return MessageCreateSpec.validate(new MessageCreateSpec(newValue, this.nonce(), this.tts(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.messageReference(), this.components()));
    }

    public MessageCreateSpec withNonce(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return MessageCreateSpec.validate(new MessageCreateSpec(this.content(), newValue, this.tts(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.messageReference(), this.components()));
    }

    public MessageCreateSpec withNonce(String value) {
        Possible<String> newValue = Possible.of(value);
        return MessageCreateSpec.validate(new MessageCreateSpec(this.content(), newValue, this.tts(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.messageReference(), this.components()));
    }

    public MessageCreateSpec withTts(Possible<Boolean> value) {
        Possible<Boolean> newValue = Objects.requireNonNull(value);
        return MessageCreateSpec.validate(new MessageCreateSpec(this.content(), this.nonce(), newValue, this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.messageReference(), this.components()));
    }

    public MessageCreateSpec withTts(Boolean value) {
        Possible<Boolean> newValue = Possible.of(value);
        return MessageCreateSpec.validate(new MessageCreateSpec(this.content(), this.nonce(), newValue, this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.messageReference(), this.components()));
    }

    public MessageCreateSpec withEmbeds(Possible<List<EmbedCreateSpec>> possible) {
        Possible<List<EmbedCreateSpec>> newValue = Objects.requireNonNull(possible);
        return MessageCreateSpec.validate(new MessageCreateSpec(this.content(), this.nonce(), this.tts(), newValue, this.files, this.fileSpoilers, this.allowedMentions(), this.messageReference(), this.components()));
    }

    public MessageCreateSpec withEmbeds(Iterable<EmbedCreateSpec> elements) {
        Possible<List<EmbedCreateSpec>> newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return MessageCreateSpec.validate(new MessageCreateSpec(this.content(), this.nonce(), this.tts(), newValue, this.files, this.fileSpoilers, this.allowedMentions(), this.messageReference(), this.components()));
    }

    @SafeVarargs
    public final MessageCreateSpec withEmbeds(EmbedCreateSpec ... elements) {
        Possible<List<EmbedCreateSpec>> newValue = Possible.of(Arrays.asList(elements));
        return MessageCreateSpec.validate(new MessageCreateSpec(this.content(), this.nonce(), this.tts(), newValue, this.files, this.fileSpoilers, this.allowedMentions(), this.messageReference(), this.components()));
    }

    public final MessageCreateSpec withFiles(MessageCreateFields.File ... elements) {
        List<MessageCreateFields.File> newValue = MessageCreateSpec.createUnmodifiableList(false, MessageCreateSpec.createSafeList(Arrays.asList(elements), true, false));
        return MessageCreateSpec.validate(new MessageCreateSpec(this.content(), this.nonce(), this.tts(), this.embeds(), newValue, this.fileSpoilers, this.allowedMentions(), this.messageReference(), this.components()));
    }

    public final MessageCreateSpec withFiles(Iterable<? extends MessageCreateFields.File> elements) {
        if (this.files == elements) {
            return this;
        }
        List<MessageCreateFields.File> newValue = MessageCreateSpec.createUnmodifiableList(false, MessageCreateSpec.createSafeList(elements, true, false));
        return MessageCreateSpec.validate(new MessageCreateSpec(this.content(), this.nonce(), this.tts(), this.embeds(), newValue, this.fileSpoilers, this.allowedMentions(), this.messageReference(), this.components()));
    }

    public final MessageCreateSpec withFileSpoilers(MessageCreateFields.FileSpoiler ... elements) {
        List<MessageCreateFields.FileSpoiler> newValue = MessageCreateSpec.createUnmodifiableList(false, MessageCreateSpec.createSafeList(Arrays.asList(elements), true, false));
        return MessageCreateSpec.validate(new MessageCreateSpec(this.content(), this.nonce(), this.tts(), this.embeds(), this.files, newValue, this.allowedMentions(), this.messageReference(), this.components()));
    }

    public final MessageCreateSpec withFileSpoilers(Iterable<? extends MessageCreateFields.FileSpoiler> elements) {
        if (this.fileSpoilers == elements) {
            return this;
        }
        List<MessageCreateFields.FileSpoiler> newValue = MessageCreateSpec.createUnmodifiableList(false, MessageCreateSpec.createSafeList(elements, true, false));
        return MessageCreateSpec.validate(new MessageCreateSpec(this.content(), this.nonce(), this.tts(), this.embeds(), this.files, newValue, this.allowedMentions(), this.messageReference(), this.components()));
    }

    public MessageCreateSpec withAllowedMentions(Possible<AllowedMentions> value) {
        Possible<AllowedMentions> newValue = Objects.requireNonNull(value);
        return MessageCreateSpec.validate(new MessageCreateSpec(this.content(), this.nonce(), this.tts(), this.embeds(), this.files, this.fileSpoilers, newValue, this.messageReference(), this.components()));
    }

    public MessageCreateSpec withAllowedMentions(AllowedMentions value) {
        Possible<AllowedMentions> newValue = Possible.of(value);
        return MessageCreateSpec.validate(new MessageCreateSpec(this.content(), this.nonce(), this.tts(), this.embeds(), this.files, this.fileSpoilers, newValue, this.messageReference(), this.components()));
    }

    public MessageCreateSpec withMessageReference(Possible<Snowflake> value) {
        Possible<Snowflake> newValue = Objects.requireNonNull(value);
        return MessageCreateSpec.validate(new MessageCreateSpec(this.content(), this.nonce(), this.tts(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), newValue, this.components()));
    }

    public MessageCreateSpec withMessageReference(Snowflake value) {
        Possible<Snowflake> newValue = Possible.of(value);
        return MessageCreateSpec.validate(new MessageCreateSpec(this.content(), this.nonce(), this.tts(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), newValue, this.components()));
    }

    public MessageCreateSpec withComponents(Possible<List<LayoutComponent>> possible) {
        Possible<List<LayoutComponent>> newValue = Objects.requireNonNull(possible);
        return MessageCreateSpec.validate(new MessageCreateSpec(this.content(), this.nonce(), this.tts(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.messageReference(), newValue));
    }

    public MessageCreateSpec withComponents(Iterable<LayoutComponent> elements) {
        Possible<List<LayoutComponent>> newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return MessageCreateSpec.validate(new MessageCreateSpec(this.content(), this.nonce(), this.tts(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.messageReference(), newValue));
    }

    @SafeVarargs
    public final MessageCreateSpec withComponents(LayoutComponent ... elements) {
        Possible<List<LayoutComponent>> newValue = Possible.of(Arrays.asList(elements));
        return MessageCreateSpec.validate(new MessageCreateSpec(this.content(), this.nonce(), this.tts(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.messageReference(), newValue));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof MessageCreateSpec && this.equalTo(0, (MessageCreateSpec)another);
    }

    private boolean equalTo(int synthetic, MessageCreateSpec another) {
        return this.content().equals(another.content()) && this.nonce().equals(another.nonce()) && this.tts().equals(another.tts()) && Objects.equals(this.embeds_value, another.embeds_value) && this.files.equals(another.files) && this.fileSpoilers.equals(another.fileSpoilers) && this.allowedMentions().equals(another.allowedMentions()) && this.messageReference().equals(another.messageReference()) && Objects.equals(this.components_value, another.components_value);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.content().hashCode();
        h2 += (h2 << 5) + this.nonce().hashCode();
        h2 += (h2 << 5) + this.tts().hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.embeds_value);
        h2 += (h2 << 5) + this.files.hashCode();
        h2 += (h2 << 5) + this.fileSpoilers.hashCode();
        h2 += (h2 << 5) + this.allowedMentions().hashCode();
        h2 += (h2 << 5) + this.messageReference().hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.components_value);
        return h2;
    }

    public String toString() {
        return "MessageCreateSpec{content=" + this.content().toString() + ", nonce=" + this.nonce().toString() + ", tts=" + this.tts().toString() + ", embeds=" + Objects.toString(this.embeds_value) + ", files=" + this.files + ", fileSpoilers=" + this.fileSpoilers + ", allowedMentions=" + this.allowedMentions().toString() + ", messageReference=" + this.messageReference().toString() + ", components=" + Objects.toString(this.components_value) + "}";
    }

    public static MessageCreateSpec create() {
        return INSTANCE;
    }

    private static MessageCreateSpec validate(MessageCreateSpec instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    static MessageCreateSpec copyOf(MessageCreateSpecGenerator instance) {
        if (instance instanceof MessageCreateSpec) {
            return (MessageCreateSpec)instance;
        }
        return MessageCreateSpec.builder().from(instance).build();
    }

    public boolean isContentPresent() {
        return !this.content_absent;
    }

    public String contentOrElse(String defaultValue) {
        return !this.content_absent ? this.content_value : defaultValue;
    }

    public boolean isNoncePresent() {
        return !this.nonce_absent;
    }

    public String nonceOrElse(String defaultValue) {
        return !this.nonce_absent ? this.nonce_value : defaultValue;
    }

    public boolean isTtsPresent() {
        return !this.tts_absent;
    }

    public Boolean ttsOrElse(Boolean defaultValue) {
        return !this.tts_absent ? this.tts_value : defaultValue;
    }

    public boolean isEmbedsPresent() {
        return !this.embeds_absent;
    }

    public List<EmbedCreateSpec> embedsOrElse(List<EmbedCreateSpec> defaultValue) {
        return !this.embeds_absent ? this.embeds_value : defaultValue;
    }

    public boolean isAllowedMentionsPresent() {
        return !this.allowedMentions_absent;
    }

    public AllowedMentions allowedMentionsOrElse(AllowedMentions defaultValue) {
        return !this.allowedMentions_absent ? this.allowedMentions_value : defaultValue;
    }

    public boolean isMessageReferencePresent() {
        return !this.messageReference_absent;
    }

    public Snowflake messageReferenceOrElse(Snowflake defaultValue) {
        return !this.messageReference_absent ? this.messageReference_value : defaultValue;
    }

    public boolean isComponentsPresent() {
        return !this.components_absent;
    }

    public List<LayoutComponent> componentsOrElse(List<LayoutComponent> defaultValue) {
        return !this.components_absent ? this.components_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="MessageCreateSpecGenerator", generator="Immutables")
    public static final class Builder {
        private static final long OPT_BIT_FILES = 1L;
        private static final long OPT_BIT_FILE_SPOILERS = 2L;
        private long optBits;
        private Possible<String> content_possible = Possible.absent();
        private Possible<String> nonce_possible = Possible.absent();
        private Possible<Boolean> tts_possible = Possible.absent();
        private List<EmbedCreateSpec> embeds_list = null;
        private Possible<AllowedMentions> allowedMentions_possible = Possible.absent();
        private Possible<Snowflake> messageReference_possible = Possible.absent();
        private List<LayoutComponent> components_list = null;
        private List<MessageCreateFields.File> files = new ArrayList<MessageCreateFields.File>();
        private List<MessageCreateFields.FileSpoiler> fileSpoilers = new ArrayList<MessageCreateFields.FileSpoiler>();

        private Builder() {
        }

        public final Builder from(MessageCreateSpec instance) {
            return this.from((MessageCreateSpecGenerator)instance);
        }

        @CanIgnoreReturnValue
        final Builder from(MessageCreateSpecGenerator instance) {
            Objects.requireNonNull(instance, "instance");
            this.content(instance.content());
            this.nonce(instance.nonce());
            this.tts(instance.tts());
            this.embeds(instance.embeds());
            this.addAllFiles(instance.files());
            this.addAllFileSpoilers(instance.fileSpoilers());
            this.allowedMentions(instance.allowedMentions());
            this.messageReference(instance.messageReference());
            this.components(instance.components());
            return this;
        }

        @CanIgnoreReturnValue
        public Builder content(Possible<String> value) {
            this.content_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder content(String value) {
            this.content_possible = Possible.of(value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder nonce(Possible<String> value) {
            this.nonce_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder nonce(String value) {
            this.nonce_possible = Possible.of(value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder tts(Possible<Boolean> value) {
            this.tts_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder tts(Boolean value) {
            this.tts_possible = Possible.of(value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addEmbed(EmbedCreateSpec element) {
            this.embeds_getOrCreate().add(element);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAllEmbeds(List<EmbedCreateSpec> elements) {
            this.embeds_getOrCreate().addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder embeds(Possible<List<EmbedCreateSpec>> elements) {
            this.embeds_list = null;
            elements.toOptional().ifPresent(e -> this.embeds_getOrCreate().addAll((Collection<EmbedCreateSpec>)e));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder embeds(List<EmbedCreateSpec> elements) {
            this.embeds_list = new ArrayList<EmbedCreateSpec>(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder embeds(Iterable<EmbedCreateSpec> elements) {
            this.embeds_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addFile(MessageCreateFields.File element) {
            element = ImmutableMessageCreateFields.File.copyOf(element);
            this.files.add(Objects.requireNonNull(element, "files element"));
            this.optBits |= 1L;
            return this;
        }

        public final Builder addFile(String name, InputStream inputStream) {
            return this.addFile(ImmutableMessageCreateFields.File.of(name, inputStream));
        }

        @CanIgnoreReturnValue
        public final Builder addFiles(MessageCreateFields.File ... elements) {
            for (MessageCreateFields.File element : elements) {
                element = ImmutableMessageCreateFields.File.copyOf(element);
                this.files.add(Objects.requireNonNull(element, "files element"));
            }
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder files(Iterable<? extends MessageCreateFields.File> elements) {
            this.files.clear();
            return this.addAllFiles(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllFiles(Iterable<? extends MessageCreateFields.File> elements) {
            for (MessageCreateFields.File file : elements) {
                ImmutableMessageCreateFields.File file2 = ImmutableMessageCreateFields.File.copyOf(file);
                this.files.add(Objects.requireNonNull(file2, "files element"));
            }
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addFileSpoiler(MessageCreateFields.FileSpoiler element) {
            element = ImmutableMessageCreateFields.FileSpoiler.copyOf(element);
            this.fileSpoilers.add(Objects.requireNonNull(element, "fileSpoilers element"));
            this.optBits |= 2L;
            return this;
        }

        public final Builder addFileSpoiler(String name, InputStream inputStream) {
            return this.addFileSpoiler(ImmutableMessageCreateFields.FileSpoiler.of(name, inputStream));
        }

        @CanIgnoreReturnValue
        public final Builder addFileSpoilers(MessageCreateFields.FileSpoiler ... elements) {
            for (MessageCreateFields.FileSpoiler element : elements) {
                element = ImmutableMessageCreateFields.FileSpoiler.copyOf(element);
                this.fileSpoilers.add(Objects.requireNonNull(element, "fileSpoilers element"));
            }
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder fileSpoilers(Iterable<? extends MessageCreateFields.FileSpoiler> elements) {
            this.fileSpoilers.clear();
            return this.addAllFileSpoilers(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllFileSpoilers(Iterable<? extends MessageCreateFields.FileSpoiler> elements) {
            for (MessageCreateFields.FileSpoiler fileSpoiler : elements) {
                ImmutableMessageCreateFields.FileSpoiler fileSpoiler2 = ImmutableMessageCreateFields.FileSpoiler.copyOf(fileSpoiler);
                this.fileSpoilers.add(Objects.requireNonNull(fileSpoiler2, "fileSpoilers element"));
            }
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder allowedMentions(Possible<AllowedMentions> value) {
            this.allowedMentions_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder allowedMentions(AllowedMentions value) {
            this.allowedMentions_possible = Possible.of(value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder messageReference(Possible<Snowflake> value) {
            this.messageReference_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder messageReference(Snowflake value) {
            this.messageReference_possible = Possible.of(value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addComponent(LayoutComponent element) {
            this.components_getOrCreate().add(element);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAllComponents(List<LayoutComponent> elements) {
            this.components_getOrCreate().addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder components(Possible<List<LayoutComponent>> elements) {
            this.components_list = null;
            elements.toOptional().ifPresent(e -> this.components_getOrCreate().addAll((Collection<LayoutComponent>)e));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder components(List<LayoutComponent> elements) {
            this.components_list = new ArrayList<LayoutComponent>(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder components(Iterable<LayoutComponent> elements) {
            this.components_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
            return this;
        }

        public MessageCreateSpec build() {
            return MessageCreateSpec.validate(new MessageCreateSpec(this));
        }

        private boolean filesIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean fileSpoilersIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private Possible<String> content_build() {
            return this.content_possible;
        }

        private Possible<String> nonce_build() {
            return this.nonce_possible;
        }

        private Possible<Boolean> tts_build() {
            return this.tts_possible;
        }

        private Possible<List<EmbedCreateSpec>> embeds_build() {
            return this.embeds_list == null ? Possible.absent() : Possible.of(this.embeds_list);
        }

        private List<EmbedCreateSpec> embeds_getOrCreate() {
            if (this.embeds_list == null) {
                this.embeds_list = new ArrayList<EmbedCreateSpec>();
            }
            return this.embeds_list;
        }

        private Possible<AllowedMentions> allowedMentions_build() {
            return this.allowedMentions_possible;
        }

        private Possible<Snowflake> messageReference_build() {
            return this.messageReference_possible;
        }

        private Possible<List<LayoutComponent>> components_build() {
            return this.components_list == null ? Possible.absent() : Possible.of(this.components_list);
        }

        private List<LayoutComponent> components_getOrCreate() {
            if (this.components_list == null) {
                this.components_list = new ArrayList<LayoutComponent>();
            }
            return this.components_list;
        }
    }

    @Generated(from="MessageCreateSpecGenerator", generator="Immutables")
    private final class InitShim {
        private byte filesBuildStage = 0;
        private List<MessageCreateFields.File> files;
        private byte fileSpoilersBuildStage = 0;
        private List<MessageCreateFields.FileSpoiler> fileSpoilers;

        private InitShim() {
        }

        List<MessageCreateFields.File> files() {
            if (this.filesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.filesBuildStage == 0) {
                this.filesBuildStage = (byte)-1;
                this.files = MessageCreateSpec.createUnmodifiableList(false, MessageCreateSpec.createSafeList(MessageCreateSpec.this.filesInitialize(), true, false));
                this.filesBuildStage = 1;
            }
            return this.files;
        }

        void files(List<MessageCreateFields.File> files) {
            this.files = files;
            this.filesBuildStage = 1;
        }

        List<MessageCreateFields.FileSpoiler> fileSpoilers() {
            if (this.fileSpoilersBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.fileSpoilersBuildStage == 0) {
                this.fileSpoilersBuildStage = (byte)-1;
                this.fileSpoilers = MessageCreateSpec.createUnmodifiableList(false, MessageCreateSpec.createSafeList(MessageCreateSpec.this.fileSpoilersInitialize(), true, false));
                this.fileSpoilersBuildStage = 1;
            }
            return this.fileSpoilers;
        }

        void fileSpoilers(List<MessageCreateFields.FileSpoiler> fileSpoilers) {
            this.fileSpoilers = fileSpoilers;
            this.fileSpoilersBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.filesBuildStage == -1) {
                attributes.add("files");
            }
            if (this.fileSpoilersBuildStage == -1) {
                attributes.add("fileSpoilers");
            }
            return "Cannot build MessageCreateSpec, attribute initializers form cycle " + attributes;
        }
    }
}

