/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import discord4j.common.util.Snowflake;
import discord4j.core.object.PermissionOverwrite;
import discord4j.core.spec.TextChannelCreateSpecGenerator;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

@Generated(from="TextChannelCreateSpecGenerator", generator="Immutables")
public final class TextChannelCreateSpec
implements TextChannelCreateSpecGenerator {
    @Nullable
    private final String reason;
    private final String name;
    private final String topic_value;
    private final boolean topic_absent;
    private final Integer rateLimitPerUser_value;
    private final boolean rateLimitPerUser_absent;
    private final Integer position_value;
    private final boolean position_absent;
    private final List<PermissionOverwrite> permissionOverwrites_value;
    private final boolean permissionOverwrites_absent;
    private final Snowflake parentId_value;
    private final boolean parentId_absent;
    private final Boolean nsfw_value;
    private final boolean nsfw_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private TextChannelCreateSpec(String name) {
        this.name = Objects.requireNonNull(name, "name");
        this.reason = null;
        Possible topic$impl = Possible.absent();
        Possible rateLimitPerUser$impl = Possible.absent();
        Possible position$impl = Possible.absent();
        Possible permissionOverwrites$impl = Possible.absent();
        Possible parentId$impl = Possible.absent();
        Possible nsfw$impl = Possible.absent();
        this.topic_value = topic$impl.toOptional().orElse(null);
        this.topic_absent = topic$impl.isAbsent();
        this.rateLimitPerUser_value = rateLimitPerUser$impl.toOptional().orElse(null);
        this.rateLimitPerUser_absent = rateLimitPerUser$impl.isAbsent();
        this.position_value = position$impl.toOptional().orElse(null);
        this.position_absent = position$impl.isAbsent();
        this.permissionOverwrites_value = permissionOverwrites$impl.toOptional().orElse(null);
        this.permissionOverwrites_absent = permissionOverwrites$impl.isAbsent();
        this.parentId_value = parentId$impl.toOptional().orElse(null);
        this.parentId_absent = parentId$impl.isAbsent();
        this.nsfw_value = nsfw$impl.toOptional().orElse(null);
        this.nsfw_absent = nsfw$impl.isAbsent();
        this.initShim = null;
    }

    private TextChannelCreateSpec(@Nullable String reason, String name, Possible<String> topic, Possible<Integer> rateLimitPerUser, Possible<Integer> position, Possible<List<PermissionOverwrite>> permissionOverwrites, Possible<Snowflake> parentId, Possible<Boolean> nsfw) {
        this.reason = reason;
        this.name = name;
        Possible<String> topic$impl = topic;
        Possible<Integer> rateLimitPerUser$impl = rateLimitPerUser;
        Possible<Integer> position$impl = position;
        Possible<List<PermissionOverwrite>> permissionOverwrites$impl = permissionOverwrites;
        Possible<Snowflake> parentId$impl = parentId;
        Possible<Boolean> nsfw$impl = nsfw;
        this.topic_value = topic$impl.toOptional().orElse(null);
        this.topic_absent = topic$impl.isAbsent();
        this.rateLimitPerUser_value = rateLimitPerUser$impl.toOptional().orElse(null);
        this.rateLimitPerUser_absent = rateLimitPerUser$impl.isAbsent();
        this.position_value = position$impl.toOptional().orElse(null);
        this.position_absent = position$impl.isAbsent();
        this.permissionOverwrites_value = permissionOverwrites$impl.toOptional().orElse(null);
        this.permissionOverwrites_absent = permissionOverwrites$impl.isAbsent();
        this.parentId_value = parentId$impl.toOptional().orElse(null);
        this.parentId_absent = parentId$impl.isAbsent();
        this.nsfw_value = nsfw$impl.toOptional().orElse(null);
        this.nsfw_absent = nsfw$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @Nullable
    public String reason() {
        return this.reason;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Possible<String> topic() {
        return this.topic_absent ? Possible.absent() : Possible.of(this.topic_value);
    }

    @Override
    public Possible<Integer> rateLimitPerUser() {
        return this.rateLimitPerUser_absent ? Possible.absent() : Possible.of(this.rateLimitPerUser_value);
    }

    @Override
    public Possible<Integer> position() {
        return this.position_absent ? Possible.absent() : Possible.of(this.position_value);
    }

    @Override
    public Possible<List<PermissionOverwrite>> permissionOverwrites() {
        return this.permissionOverwrites_absent ? Possible.absent() : Possible.of(this.permissionOverwrites_value);
    }

    @Override
    public Possible<Snowflake> parentId() {
        return this.parentId_absent ? Possible.absent() : Possible.of(this.parentId_value);
    }

    @Override
    public Possible<Boolean> nsfw() {
        return this.nsfw_absent ? Possible.absent() : Possible.of(this.nsfw_value);
    }

    public final TextChannelCreateSpec withReason(@Nullable String value) {
        if (Objects.equals(this.reason, value)) {
            return this;
        }
        return new TextChannelCreateSpec(value, this.name, this.topic(), this.rateLimitPerUser(), this.position(), this.permissionOverwrites(), this.parentId(), this.nsfw());
    }

    public final TextChannelCreateSpec withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new TextChannelCreateSpec(this.reason, newValue, this.topic(), this.rateLimitPerUser(), this.position(), this.permissionOverwrites(), this.parentId(), this.nsfw());
    }

    public TextChannelCreateSpec withTopic(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return new TextChannelCreateSpec(this.reason, this.name, newValue, this.rateLimitPerUser(), this.position(), this.permissionOverwrites(), this.parentId(), this.nsfw());
    }

    public TextChannelCreateSpec withTopic(String value) {
        Possible<String> newValue = Possible.of(value);
        return new TextChannelCreateSpec(this.reason, this.name, newValue, this.rateLimitPerUser(), this.position(), this.permissionOverwrites(), this.parentId(), this.nsfw());
    }

    public TextChannelCreateSpec withRateLimitPerUser(Possible<Integer> value) {
        Possible<Integer> newValue = Objects.requireNonNull(value);
        return new TextChannelCreateSpec(this.reason, this.name, this.topic(), newValue, this.position(), this.permissionOverwrites(), this.parentId(), this.nsfw());
    }

    public TextChannelCreateSpec withRateLimitPerUser(Integer value) {
        Possible<Integer> newValue = Possible.of(value);
        return new TextChannelCreateSpec(this.reason, this.name, this.topic(), newValue, this.position(), this.permissionOverwrites(), this.parentId(), this.nsfw());
    }

    public TextChannelCreateSpec withPosition(Possible<Integer> value) {
        Possible<Integer> newValue = Objects.requireNonNull(value);
        return new TextChannelCreateSpec(this.reason, this.name, this.topic(), this.rateLimitPerUser(), newValue, this.permissionOverwrites(), this.parentId(), this.nsfw());
    }

    public TextChannelCreateSpec withPosition(Integer value) {
        Possible<Integer> newValue = Possible.of(value);
        return new TextChannelCreateSpec(this.reason, this.name, this.topic(), this.rateLimitPerUser(), newValue, this.permissionOverwrites(), this.parentId(), this.nsfw());
    }

    public TextChannelCreateSpec withPermissionOverwrites(Possible<List<PermissionOverwrite>> possible) {
        Possible<List<PermissionOverwrite>> newValue = Objects.requireNonNull(possible);
        return new TextChannelCreateSpec(this.reason, this.name, this.topic(), this.rateLimitPerUser(), this.position(), newValue, this.parentId(), this.nsfw());
    }

    public TextChannelCreateSpec withPermissionOverwrites(Iterable<PermissionOverwrite> elements) {
        Possible<List<PermissionOverwrite>> newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return new TextChannelCreateSpec(this.reason, this.name, this.topic(), this.rateLimitPerUser(), this.position(), newValue, this.parentId(), this.nsfw());
    }

    @SafeVarargs
    public final TextChannelCreateSpec withPermissionOverwrites(PermissionOverwrite ... elements) {
        Possible<List<PermissionOverwrite>> newValue = Possible.of(Arrays.asList(elements));
        return new TextChannelCreateSpec(this.reason, this.name, this.topic(), this.rateLimitPerUser(), this.position(), newValue, this.parentId(), this.nsfw());
    }

    public TextChannelCreateSpec withParentId(Possible<Snowflake> value) {
        Possible<Snowflake> newValue = Objects.requireNonNull(value);
        return new TextChannelCreateSpec(this.reason, this.name, this.topic(), this.rateLimitPerUser(), this.position(), this.permissionOverwrites(), newValue, this.nsfw());
    }

    public TextChannelCreateSpec withParentId(Snowflake value) {
        Possible<Snowflake> newValue = Possible.of(value);
        return new TextChannelCreateSpec(this.reason, this.name, this.topic(), this.rateLimitPerUser(), this.position(), this.permissionOverwrites(), newValue, this.nsfw());
    }

    public TextChannelCreateSpec withNsfw(Possible<Boolean> value) {
        Possible<Boolean> newValue = Objects.requireNonNull(value);
        return new TextChannelCreateSpec(this.reason, this.name, this.topic(), this.rateLimitPerUser(), this.position(), this.permissionOverwrites(), this.parentId(), newValue);
    }

    public TextChannelCreateSpec withNsfw(Boolean value) {
        Possible<Boolean> newValue = Possible.of(value);
        return new TextChannelCreateSpec(this.reason, this.name, this.topic(), this.rateLimitPerUser(), this.position(), this.permissionOverwrites(), this.parentId(), newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof TextChannelCreateSpec && this.equalTo(0, (TextChannelCreateSpec)another);
    }

    private boolean equalTo(int synthetic, TextChannelCreateSpec another) {
        return Objects.equals(this.reason, another.reason) && this.name.equals(another.name) && this.topic().equals(another.topic()) && this.rateLimitPerUser().equals(another.rateLimitPerUser()) && this.position().equals(another.position()) && Objects.equals(this.permissionOverwrites_value, another.permissionOverwrites_value) && this.parentId().equals(another.parentId()) && this.nsfw().equals(another.nsfw());
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.reason);
        h2 += (h2 << 5) + this.name.hashCode();
        h2 += (h2 << 5) + this.topic().hashCode();
        h2 += (h2 << 5) + this.rateLimitPerUser().hashCode();
        h2 += (h2 << 5) + this.position().hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.permissionOverwrites_value);
        h2 += (h2 << 5) + this.parentId().hashCode();
        h2 += (h2 << 5) + this.nsfw().hashCode();
        return h2;
    }

    public String toString() {
        return "TextChannelCreateSpec{reason=" + this.reason + ", name=" + this.name + ", topic=" + this.topic().toString() + ", rateLimitPerUser=" + this.rateLimitPerUser().toString() + ", position=" + this.position().toString() + ", permissionOverwrites=" + Objects.toString(this.permissionOverwrites_value) + ", parentId=" + this.parentId().toString() + ", nsfw=" + this.nsfw().toString() + "}";
    }

    public static TextChannelCreateSpec of(String name) {
        return new TextChannelCreateSpec(name);
    }

    static TextChannelCreateSpec copyOf(TextChannelCreateSpecGenerator instance) {
        if (instance instanceof TextChannelCreateSpec) {
            return (TextChannelCreateSpec)instance;
        }
        return TextChannelCreateSpec.builder().from(instance).build();
    }

    public boolean isTopicPresent() {
        return !this.topic_absent;
    }

    public String topicOrElse(String defaultValue) {
        return !this.topic_absent ? this.topic_value : defaultValue;
    }

    public boolean isRateLimitPerUserPresent() {
        return !this.rateLimitPerUser_absent;
    }

    public Integer rateLimitPerUserOrElse(Integer defaultValue) {
        return !this.rateLimitPerUser_absent ? this.rateLimitPerUser_value : defaultValue;
    }

    public boolean isPositionPresent() {
        return !this.position_absent;
    }

    public Integer positionOrElse(Integer defaultValue) {
        return !this.position_absent ? this.position_value : defaultValue;
    }

    public boolean isPermissionOverwritesPresent() {
        return !this.permissionOverwrites_absent;
    }

    public List<PermissionOverwrite> permissionOverwritesOrElse(List<PermissionOverwrite> defaultValue) {
        return !this.permissionOverwrites_absent ? this.permissionOverwrites_value : defaultValue;
    }

    public boolean isParentIdPresent() {
        return !this.parentId_absent;
    }

    public Snowflake parentIdOrElse(Snowflake defaultValue) {
        return !this.parentId_absent ? this.parentId_value : defaultValue;
    }

    public boolean isNsfwPresent() {
        return !this.nsfw_absent;
    }

    public Boolean nsfwOrElse(Boolean defaultValue) {
        return !this.nsfw_absent ? this.nsfw_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TextChannelCreateSpecGenerator", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private long initBits = 1L;
        private Possible<String> topic_possible = Possible.absent();
        private Possible<Integer> rateLimitPerUser_possible = Possible.absent();
        private Possible<Integer> position_possible = Possible.absent();
        private List<PermissionOverwrite> permissionOverwrites_list = null;
        private Possible<Snowflake> parentId_possible = Possible.absent();
        private Possible<Boolean> nsfw_possible = Possible.absent();
        private String reason;
        private String name;

        private Builder() {
        }

        public final Builder from(TextChannelCreateSpec instance) {
            return this.from((TextChannelCreateSpecGenerator)instance);
        }

        @CanIgnoreReturnValue
        final Builder from(TextChannelCreateSpecGenerator instance) {
            Objects.requireNonNull(instance, "instance");
            String reasonValue = instance.reason();
            if (reasonValue != null) {
                this.reason(reasonValue);
            }
            this.name(instance.name());
            this.topic(instance.topic());
            this.rateLimitPerUser(instance.rateLimitPerUser());
            this.position(instance.position());
            this.permissionOverwrites(instance.permissionOverwrites());
            this.parentId(instance.parentId());
            this.nsfw(instance.nsfw());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder reason(@Nullable String reason) {
            this.reason = reason;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder topic(Possible<String> value) {
            this.topic_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder topic(String value) {
            this.topic_possible = Possible.of(value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder rateLimitPerUser(Possible<Integer> value) {
            this.rateLimitPerUser_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder rateLimitPerUser(Integer value) {
            this.rateLimitPerUser_possible = Possible.of(value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder position(Possible<Integer> value) {
            this.position_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder position(Integer value) {
            this.position_possible = Possible.of(value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addPermissionOverwrite(PermissionOverwrite element) {
            this.permissionOverwrites_getOrCreate().add(element);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAllPermissionOverwrites(List<PermissionOverwrite> elements) {
            this.permissionOverwrites_getOrCreate().addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder permissionOverwrites(Possible<List<PermissionOverwrite>> elements) {
            this.permissionOverwrites_list = null;
            elements.toOptional().ifPresent(e -> this.permissionOverwrites_getOrCreate().addAll((Collection<PermissionOverwrite>)e));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder permissionOverwrites(List<PermissionOverwrite> elements) {
            this.permissionOverwrites_list = new ArrayList<PermissionOverwrite>(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder permissionOverwrites(Iterable<PermissionOverwrite> elements) {
            this.permissionOverwrites_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
            return this;
        }

        @CanIgnoreReturnValue
        public Builder parentId(Possible<Snowflake> value) {
            this.parentId_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder parentId(Snowflake value) {
            this.parentId_possible = Possible.of(value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder nsfw(Possible<Boolean> value) {
            this.nsfw_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder nsfw(Boolean value) {
            this.nsfw_possible = Possible.of(value);
            return this;
        }

        public TextChannelCreateSpec build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new TextChannelCreateSpec(this.reason, this.name, this.topic_build(), this.rateLimitPerUser_build(), this.position_build(), this.permissionOverwrites_build(), this.parentId_build(), this.nsfw_build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build TextChannelCreateSpec, some of required attributes are not set " + attributes;
        }

        private Possible<String> topic_build() {
            return this.topic_possible;
        }

        private Possible<Integer> rateLimitPerUser_build() {
            return this.rateLimitPerUser_possible;
        }

        private Possible<Integer> position_build() {
            return this.position_possible;
        }

        private Possible<List<PermissionOverwrite>> permissionOverwrites_build() {
            return this.permissionOverwrites_list == null ? Possible.absent() : Possible.of(this.permissionOverwrites_list);
        }

        private List<PermissionOverwrite> permissionOverwrites_getOrCreate() {
            if (this.permissionOverwrites_list == null) {
                this.permissionOverwrites_list = new ArrayList<PermissionOverwrite>();
            }
            return this.permissionOverwrites_list;
        }

        private Possible<Snowflake> parentId_build() {
            return this.parentId_possible;
        }

        private Possible<Boolean> nsfw_build() {
            return this.nsfw_possible;
        }
    }

    @Generated(from="TextChannelCreateSpecGenerator", generator="Immutables")
    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build TextChannelCreateSpec, attribute initializers form cycle " + attributes;
        }
    }
}

