/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.entity;

import discord4j.common.util.Snowflake;
import discord4j.discordjson.json.GuildScheduledEventData;
import discord4j.discordjson.json.GuildScheduledEventModifyRequest;
import discord4j.discordjson.json.GuildScheduledEventUserData;
import discord4j.rest.RestClient;
import discord4j.rest.entity.RestGuild;
import discord4j.rest.util.PaginationUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public class RestScheduledEvent {
    private final RestClient restClient;
    private final long guildId;
    private final long id;

    private RestScheduledEvent(RestClient restClient, long guildId, long id) {
        this.restClient = restClient;
        this.guildId = guildId;
        this.id = id;
    }

    public static RestScheduledEvent create(RestClient restClient, Snowflake guildId, Snowflake id) {
        return new RestScheduledEvent(restClient, guildId.asLong(), id.asLong());
    }

    static RestScheduledEvent create(RestClient restClient, long guildId, long id) {
        return new RestScheduledEvent(restClient, guildId, id);
    }

    public Snowflake getGuildId() {
        return Snowflake.of(this.guildId);
    }

    public Snowflake getId() {
        return Snowflake.of(this.id);
    }

    public RestGuild guild() {
        return RestGuild.create(this.restClient, this.guildId);
    }

    public Mono<GuildScheduledEventData> edit(GuildScheduledEventModifyRequest request, @Nullable String reason) {
        return this.restClient.getGuildService().modifyScheduledEvent(this.guildId, this.id, request, reason);
    }

    public Mono<Void> delete(@Nullable String reason) {
        return this.restClient.getGuildService().deleteScheduledEvent(this.guildId, this.id, reason);
    }

    public Flux<GuildScheduledEventUserData> getSubscribedUsersBefore(Snowflake userId, @Nullable Boolean withMember) {
        Function doRequest = params -> {
            Optional.ofNullable(withMember).ifPresent(value -> params.put("with_member", value));
            return this.restClient.getGuildService().getScheduledEventUsers(this.guildId, this.id, (Map<String, Object>)params);
        };
        return PaginationUtil.paginateBefore(doRequest, data -> Snowflake.asLong(data.user().id()), userId.asLong(), 100);
    }

    public Flux<GuildScheduledEventUserData> getSubscribedUsersAfter(Snowflake userId, @Nullable Boolean withMember) {
        Function doRequest = params -> {
            Optional.ofNullable(withMember).ifPresent(value -> params.put("with_member", value));
            return this.restClient.getGuildService().getScheduledEventUsers(this.guildId, this.id, (Map<String, Object>)params);
        };
        return PaginationUtil.paginateAfter(doRequest, data -> Snowflake.asLong(data.user().id()), userId.asLong(), 100);
    }

    public Mono<GuildScheduledEventData> getData(@Nullable Boolean withUserCount) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        Optional.ofNullable(withUserCount).ifPresent(value -> queryParams.put("with_user_count", value));
        return this.restClient.getGuildService().getScheduledEvent(this.guildId, this.id, queryParams);
    }
}

