/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.biene;

import com.gmail.berndivader.biene.Helper;
import com.gmail.berndivader.biene.Logger;
import com.gmail.berndivader.biene.Utils;
import com.gmail.berndivader.biene.config.Config;
import com.gmail.berndivader.biene.db.QueryBatchTask;
import com.gmail.berndivader.biene.db.UpdateShopTask;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class Batcher
implements Runnable {
    public static final ConcurrentLinkedQueue<QueryBatchTask> QUERY_STACK = new ConcurrentLinkedQueue();
    public long update_start;
    public boolean auto_update = Config.data.getAutoUpdate();
    private long startTime;
    private QueryBatchTask current;

    public Batcher() {
        this.update_start = Config.data.getUpdateInterval();
        if (!QUERY_STACK.isEmpty() && (this.current = QUERY_STACK.poll()) != null) {
            this.current.batch();
        }
        this.startTime = Utils.getCurrentTimeMinutes();
        Helper.scheduler.scheduleAtFixedRate(this, 0L, 200L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void run() {
        long elapsedTime;
        if (Helper.scheduler.isShutdown()) {
            return;
        }
        if (this.auto_update && (elapsedTime = Utils.getCurrentTimeMinutes() - this.startTime) >= this.update_start) {
            this.startTime = Utils.getCurrentTimeMinutes();
            new UpdateShopTask(Config.data.getWinlineQuery());
        }
        if (this.current != null && this.current.getRunningTime() / 60000L > this.current.max_time && !this.current.future.isDone() && !this.current.future.isCancelled()) {
            try {
                this.current.future.get(3L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                Logger.$("Cancelled task ".concat(this.current.getClass().getName()).concat(" because of timeout."), false);
                this.current.future.cancel(false);
            }
        }
        if ((this.current == null || this.current.future.isDone() || this.current.future.isCancelled()) && !QUERY_STACK.isEmpty() && (this.current = QUERY_STACK.poll()) != null) {
            this.current.batch();
        }
    }
}

