/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.biene.config;

import com.gmail.berndivader.biene.Biene;
import com.gmail.berndivader.biene.Logger;
import com.gmail.berndivader.biene.Utils;
import com.gmail.berndivader.biene.config.Gdata;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Scanner;

public class Config {
    public static File config_dir;
    public static File config_file;
    public static Gdata data;
    public static int version;

    public Config() {
        if (!config_dir.exists() || !config_file.exists()) {
            Config.createDefault();
        } else if (Config.loadConfig()) {
            Logger.$("Konfiguration erfolgfreich geladen.", false, false);
        }
        if (data.getConfig_version() < version) {
            data.setConfig_version(version);
            Logger.$("Konfigurationsdatei \u00c4lter als Biene, schreibe default.", false);
            Config.saveConfig();
            if (Config.loadConfig()) {
                Logger.$("Konfiguration erfolgreich geladen.", false, false);
            }
        }
    }

    private static String getCSVHeader() {
        return Config.inputstream2String(Biene.class.getResourceAsStream("/csv_header.txt"));
    }

    private static void getVersion() {
        String parse = Config.inputstream2String(Biene.class.getResourceAsStream("/version.info"));
        if (parse != null) {
            version = Integer.parseInt(parse);
        }
        Logger.$("Biene ".concat("20220112").concat(" - Config: ") + version, false);
    }

    public static boolean loadConfig() {
        boolean ok = true;
        try (FileReader reader = new FileReader(config_file.getAbsoluteFile());){
            data = Utils.GSON.fromJson((Reader)reader, Gdata.class);
        }
        catch (IOException e) {
            ok = false;
            Logger.$(e);
        }
        if (!ok) {
            Logger.$("Konfiguration konnte nicht geladen werden.", false, true);
        } else if (data.getCSVHeader() == null || data.getCSVHeader().isEmpty()) {
            data.set_csv_header(Config.getCSVHeader());
        }
        return ok;
    }

    public static boolean saveConfig() {
        boolean error = false;
        try (FileWriter writer = new FileWriter(config_file.getAbsoluteFile());){
            Utils.GSON.toJson((Object)data, (Appendable)writer);
        }
        catch (IOException e) {
            error = true;
            Logger.$(e);
        }
        return error;
    }

    private static void createDefault() {
        boolean error = false;
        config_dir.mkdir();
        try (InputStreamReader reader = new InputStreamReader(Biene.class.getResourceAsStream("/config.json"));){
            data = Utils.GSON.fromJson((Reader)reader, Gdata.class);
        }
        catch (IOException e) {
            Logger.$(e);
        }
        error = Config.saveConfig();
        if (!error) {
            Logger.$("Default Konfiguration erfolgreich erstellt.", false);
        } else {
            Logger.$("Fehler beim Erstellen der default Konfiguration aufgetreten.", false, true);
            System.exit(0);
        }
    }

    static String inputstream2String(InputStream is) {
        String output = null;
        try (Scanner s = new Scanner(is);){
            s.useDelimiter("\\A");
            output = s.hasNext() ? s.next() : "";
            try {
                is.close();
            }
            catch (IOException e1) {
                Logger.$(e1);
            }
        }
        return output;
    }

    static {
        Config.getVersion();
        config_dir = new File(Utils.working_dir.getAbsolutePath() + "/config");
        config_file = new File(config_dir.getAbsolutePath() + "/config.json");
    }
}

