/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.biene.http.post;

import com.gmail.berndivader.biene.Helper;
import com.gmail.berndivader.biene.Logger;
import com.gmail.berndivader.biene.Utils;
import com.gmail.berndivader.biene.enums.Tasks;
import com.gmail.berndivader.biene.http.post.PostTask;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.client.methods.ZeroCopyConsumer;
import org.apache.http.nio.client.methods.ZeroCopyPost;
import org.w3c.dom.Document;

public class PostImageUpload
extends PostTask {
    File response_file;
    File file;
    ZeroCopyPost post;
    ZeroCopyConsumer<HttpResponse> consumer;

    public PostImageUpload(String url, File file) throws FileNotFoundException {
        super(url, null);
        this.file = file;
        this.response_file = new File("_tmp");
        this.response_file.deleteOnExit();
        Object file_name = file.getName();
        String[] parse = ((String)file_name).split("\\.", -1);
        if (parse.length > 1) {
            file_name = parse[0] + "." + parse[1].toLowerCase();
        } else if (parse.length == 1) {
            file_name = parse[0] + ".jpg";
        }
        this.post = new ZeroCopyPost(url + "&action=" + Tasks.HTTP_POST_IMAGE_UPLOAD.action() + "&file_name=" + (String)file_name + "&file_size=" + file.length(), file, ContentType.IMAGE_JPEG){

            @Override
            protected HttpEntityEnclosingRequest createRequest(URI requestURI, HttpEntity entity) {
                HttpEntityEnclosingRequest request = super.createRequest(requestURI, entity);
                return request;
            }
        };
        this.consumer = new ZeroCopyConsumer<HttpResponse>(this.response_file){

            @Override
            protected HttpResponse process(HttpResponse response, File file, ContentType content_type) throws Exception {
                if (response.getStatusLine().getStatusCode() != 200) {
                    PostImageUpload.this.failed = true;
                    Logger.$(PostImageUpload.this.command + " failed.\nFehlermeldung: " + response.getStatusLine(), false, true);
                    throw new ClientProtocolException("Upload failed:" + response.getStatusLine());
                }
                PostImageUpload.this.failed = false;
                return response;
            }
        };
        this.start();
    }

    @Override
    public HttpResponse call() throws Exception {
        Future<HttpResponse> future = this.execute(this.post);
        this.took();
        return future.get(10L, TimeUnit.MINUTES);
    }

    protected Future<HttpResponse> execute(ZeroCopyPost post) {
        return Helper.client.execute(post, this.consumer, new FutureCallback<HttpResponse>(){

            @Override
            public void failed(Exception e) {
                PostImageUpload.this.failed = true;
                Logger.$(e, false, true);
                Logger.$(PostImageUpload.this.command + " failed.\nFehlermeldung: " + e.getMessage(), false, false);
                PostImageUpload.this._failed(null);
                PostImageUpload.this.latch.countDown();
            }

            @Override
            public void completed(HttpResponse respond) {
                if (PostImageUpload.this.failed) {
                    PostImageUpload.this._failed(null);
                } else {
                    PostImageUpload.this._completed(respond);
                }
                PostImageUpload.this.latch.countDown();
            }

            @Override
            public void cancelled() {
                PostImageUpload.this.failed = true;
                Logger.$(PostImageUpload.this.command + " cancelled", false, false);
                PostImageUpload.this._failed(null);
                PostImageUpload.this.latch.countDown();
            }
        });
    }

    @Override
    public void _completed(HttpResponse response) {
        Document xml = Utils.XML.getXMLDocument(response);
        if (xml != null) {
            Map<String, String> result = PostImageUpload.mapNodes("", xml.getChildNodes(), new HashMap<String, String>());
            String file_name = result.get("OUTCOME");
            Logger.$("Image-Upload von " + file_name + " " + result.get("MESSAGE"), false, false);
            try {
                Files.delete(this.file.toPath());
            }
            catch (IOException e) {
                Logger.$(e);
            }
        } else {
            Logger.$("Image-Upload hat ungew\u00f6hnlich geantwortet.", false, true);
            this._failed(response);
        }
        this.response_file.delete();
    }

    @Override
    public void _failed(HttpResponse response) {
        this.failed = true;
        this.response_file.delete();
    }

    @Override
    protected void setMaxTime(long max) {
        this.max_time = 3L;
    }
}

