/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.biene.gui;

import com.gmail.berndivader.biene.Logger;
import com.gmail.berndivader.biene.Utils;
import com.gmail.berndivader.biene.config.Config;
import com.gmail.berndivader.biene.db.SimpleResultQuery;
import com.gmail.berndivader.biene.db.UpdatePicturesTask;
import com.gmail.berndivader.biene.enums.Tasks;
import com.gmail.berndivader.biene.gui.Main;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;

public class Settings
extends JFrame {
    Settings settings;
    private static final long serialVersionUID = 10000L;
    private JPanel contentPane;
    private TextField connection_string_field;
    private TextArea sql_wl_zu_xtc;
    private Label label_2;
    private TextField benutzer_field;
    private Label label_3;
    private TextField password_field;
    private Button speichern;
    private Label label_4;
    private TextField mesoyear_field;
    private Label label_5;
    private TextField http_string_field;
    private JPanel panel;
    private JPanel panel_1;
    private Button cancel;
    private Button restore;
    private JTabbedPane tabbedPane;
    private TextArea sql_find_changed;
    private TextArea sql_find_inserts;
    private TextArea sql_find_deletes;
    private TextArea katalog;
    private TextArea sql_update_local;
    private Checkbox autoupdate;
    private TextField upd_inverval_value;
    private Label Inverval;
    private List bilder;
    private PopupMenu bilderPopup;
    private JTextField client_info;
    private JComboBox<String> client_select;
    private int client_selected_index = 0;

    public Settings() {
        this.setTitle("Konfiguration");
        this.settings = this;
        this.setAlwaysOnTop(true);
        this.setBounds(100, 100, 628, 730);
        this.setIconImage(Main.icon_image);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(null);
        this.setContentPane(this.contentPane);
        GridBagLayout gbl_contentPane = new GridBagLayout();
        gbl_contentPane.columnWidths = new int[]{583, 0};
        gbl_contentPane.rowHeights = new int[]{0, 0, 22, 22, 22, 0, 0, 0};
        gbl_contentPane.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gbl_contentPane.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0};
        this.contentPane.setLayout(gbl_contentPane);
        this.label_5 = new Label("HTTP Connection String:");
        GridBagConstraints gbc_label_5 = new GridBagConstraints();
        gbc_label_5.anchor = 18;
        gbc_label_5.insets = new Insets(0, 0, 5, 0);
        gbc_label_5.gridx = 0;
        gbc_label_5.gridy = 0;
        this.contentPane.add((Component)this.label_5, gbc_label_5);
        this.http_string_field = new TextField();
        this.http_string_field.setFont(new Font("Monospaced", 0, 11));
        GridBagConstraints gbc_textField = new GridBagConstraints();
        gbc_textField.fill = 2;
        gbc_textField.anchor = 11;
        gbc_textField.insets = new Insets(0, 0, 5, 0);
        gbc_textField.gridx = 0;
        gbc_textField.gridy = 1;
        this.contentPane.add((Component)this.http_string_field, gbc_textField);
        Label label = new Label("MSSQL Connection String");
        GridBagConstraints gbc_label = new GridBagConstraints();
        gbc_label.anchor = 18;
        gbc_label.insets = new Insets(0, 0, 5, 0);
        gbc_label.gridx = 0;
        gbc_label.gridy = 2;
        this.contentPane.add((Component)label, gbc_label);
        this.connection_string_field = new TextField();
        this.connection_string_field.setFont(new Font("Monospaced", 0, 11));
        this.connection_string_field.setText(Config.data.connection_string());
        GridBagConstraints gbc_connection_string_field = new GridBagConstraints();
        gbc_connection_string_field.anchor = 11;
        gbc_connection_string_field.fill = 2;
        gbc_connection_string_field.insets = new Insets(0, 0, 5, 0);
        gbc_connection_string_field.gridx = 0;
        gbc_connection_string_field.gridy = 3;
        this.contentPane.add((Component)this.connection_string_field, gbc_connection_string_field);
        Label label_1 = new Label("SQL-Queries:");
        GridBagConstraints gbc_label_1 = new GridBagConstraints();
        gbc_label_1.fill = 2;
        gbc_label_1.anchor = 11;
        gbc_label_1.insets = new Insets(0, 0, 5, 0);
        gbc_label_1.gridx = 0;
        gbc_label_1.gridy = 4;
        this.contentPane.add((Component)label_1, gbc_label_1);
        this.tabbedPane = new JTabbedPane(1);
        GridBagConstraints gbc_tabbedPane = new GridBagConstraints();
        gbc_tabbedPane.gridheight = 2;
        gbc_tabbedPane.fill = 1;
        gbc_tabbedPane.insets = new Insets(0, 0, 5, 0);
        gbc_tabbedPane.gridx = 0;
        gbc_tabbedPane.gridy = 5;
        this.tabbedPane.getInputMap().put(KeyStroke.getKeyStroke("UP"), "none");
        this.tabbedPane.getInputMap().put(KeyStroke.getKeyStroke("DOWN"), "none");
        this.tabbedPane.getInputMap().put(KeyStroke.getKeyStroke("LEFT"), "none");
        this.tabbedPane.getInputMap().put(KeyStroke.getKeyStroke("RIGHT"), "none");
        this.contentPane.add((Component)this.tabbedPane, gbc_tabbedPane);
        this.sql_wl_zu_xtc = new TextArea();
        this.tabbedPane.addTab("WL zu XTC", null, this.sql_wl_zu_xtc, null);
        this.sql_wl_zu_xtc.setFont(new Font("Monospaced", 0, 11));
        this.sql_wl_zu_xtc.setText(Config.data.winline_query());
        this.sql_find_changed = new TextArea();
        this.sql_find_changed.setFont(new Font("Monospaced", 0, 11));
        this.tabbedPane.addTab("Updates", null, this.sql_find_changed, null);
        this.sql_find_changed.setText(Config.data.updates_query());
        this.sql_find_inserts = new TextArea();
        this.sql_find_inserts.setFont(new Font("Monospaced", 0, 11));
        this.tabbedPane.addTab("Inserts", null, this.sql_find_inserts, null);
        this.sql_find_inserts.setText(Config.data.inserts_query());
        this.sql_find_deletes = new TextArea();
        this.sql_find_deletes.setFont(new Font("Monospaced", 0, 11));
        this.tabbedPane.addTab("Deletes", null, this.sql_find_deletes, null);
        this.sql_find_deletes.setText(Config.data.deletes_query());
        this.sql_update_local = new TextArea();
        this.sql_update_local.setText(null);
        this.sql_update_local.setFont(new Font("Monospaced", 0, 11));
        this.tabbedPane.addTab("Verify Update", null, this.sql_update_local, null);
        this.sql_find_deletes.setText(Config.data.verify_query());
        this.katalog = new TextArea();
        this.katalog.setFont(new Font("Monospaced", 0, 11));
        this.tabbedPane.addTab("Katalog", null, this.katalog, null);
        this.katalog.setText(Config.data.katalog());
        this.bilder = new List();
        this.bilder.setFont(new Font("Monospaced", 0, 11));
        this.tabbedPane.addTab("Bilder", null, this.bilder, null);
        this.bilder.setDropTarget(new DropTarget(){
            private static final long serialVersionUID = 1L;

            @Override
            public synchronized void drop(DropTargetDropEvent e) {
                try {
                    e.acceptDrop(1);
                    java.util.List files = (java.util.List)e.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                    if (files != null) {
                        Utils.copyPictures(files);
                    }
                }
                catch (Exception ex) {
                    Logger.$(ex, false, true);
                }
            }
        });
        this.bilder.addComponentListener(new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent e) {
                Settings.this.update_pictures();
            }

            @Override
            public void componentResized(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
        this.bilder.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
            }

            @Override
            public void focusGained(FocusEvent e) {
                Settings.this.update_pictures();
            }
        });
        this.bilderPopup = new PopupMenu();
        this.bilderPopup.add(new MenuItem("Generiere Bilder am Server"));
        this.bilderPopup.add(new MenuItem("Entferne ausgew\u00e4hltes Bild"));
        this.bilderPopup.add(new MenuItem("Verzeichnis aktualisieren"));
        this.bilderPopup.getItem(0).setActionCommand("update");
        this.bilderPopup.getItem(1).setActionCommand("delete");
        this.bilderPopup.getItem(2).setActionCommand("refresh");
        this.bilderPopup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                switch (e.getActionCommand()) {
                    case "update": {
                        new UpdatePicturesTask();
                        break;
                    }
                    case "delete": {
                        Utils.deleteSelectedPictures(Settings.this.bilder.getSelectedItems());
                        break;
                    }
                }
            }
        });
        this.bilder.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 3) {
                    Settings.this.bilderPopup.show(Settings.this.bilder, e.getX(), e.getY());
                }
            }
        });
        this.bilder.add(this.bilderPopup);
        Panel misc = new Panel();
        misc.setBackground(new Color(238, 238, 238));
        this.tabbedPane.addTab("Misc", null, misc, null);
        this.client_select = new JComboBox();
        this.client_select.setFont(UIManager.getFont("Button.font"));
        JLabel client_label = new JLabel("Mandant:");
        client_label.setHorizontalAlignment(4);
        this.client_info = new JTextField();
        this.client_info.setEditable(false);
        this.client_info.setColumns(10);
        GroupLayout gl_misc = new GroupLayout(misc);
        gl_misc.setHorizontalGroup(gl_misc.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_misc.createSequentialGroup().addGap(18).addComponent(client_label, -2, 61, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.client_select, -2, 140, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.client_info, -1, 400, Short.MAX_VALUE).addContainerGap()));
        gl_misc.setVerticalGroup(gl_misc.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_misc.createSequentialGroup().addContainerGap().addGroup(gl_misc.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.client_select, -2, -1, -2).addComponent(this.client_info, -2, 26, -2).addComponent(client_label)).addContainerGap(438, Short.MAX_VALUE)));
        misc.setLayout(gl_misc);
        misc.addComponentListener(new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent e) {
                Settings.this.update_clients();
            }

            @Override
            public void componentResized(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
        this.client_select.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    Settings.this.client_selected_index = Settings.this.client_select.getSelectedIndex();
                }
            }
        });
        this.panel = new JPanel();
        GridBagConstraints gbc_panel = new GridBagConstraints();
        gbc_panel.fill = 2;
        gbc_panel.anchor = 15;
        gbc_panel.insets = new Insets(0, 0, 5, 0);
        gbc_panel.gridx = 0;
        gbc_panel.gridy = 7;
        this.contentPane.add((Component)this.panel, gbc_panel);
        this.panel.setLayout(new BoxLayout(this.panel, 0));
        this.label_4 = new Label("Gesch\u00e4ftsjahr:");
        this.label_4.setAlignment(2);
        this.panel.add(this.label_4);
        this.mesoyear_field = new TextField();
        this.panel.add(this.mesoyear_field);
        this.mesoyear_field.setFont(new Font("Monospaced", 0, 11));
        this.label_2 = new Label("Benutzername:");
        this.label_2.setAlignment(2);
        this.panel.add(this.label_2);
        this.benutzer_field = new TextField();
        this.panel.add(this.benutzer_field);
        this.benutzer_field.setFont(new Font("Monospaced", 0, 11));
        this.label_3 = new Label("Passwort:");
        this.label_3.setAlignment(2);
        this.panel.add(this.label_3);
        this.password_field = new TextField();
        this.panel.add(this.password_field);
        this.password_field.setFont(new Font("Monospaced", 0, 11));
        this.panel_1 = new JPanel();
        this.panel_1.setBackground(new Color(238, 238, 238));
        GridBagConstraints gbc_panel_1 = new GridBagConstraints();
        gbc_panel_1.anchor = 14;
        gbc_panel_1.gridx = 0;
        gbc_panel_1.gridy = 8;
        this.contentPane.add((Component)this.panel_1, gbc_panel_1);
        this.autoupdate = new Checkbox("Auto Update?");
        this.panel_1.add(this.autoupdate);
        this.Inverval = new Label("Intervall in Minuten");
        this.Inverval.setAlignment(2);
        this.panel_1.add(this.Inverval);
        this.upd_inverval_value = new TextField();
        this.upd_inverval_value.setText("60");
        this.panel_1.add(this.upd_inverval_value);
        this.speichern = new Button("Speichern");
        this.panel_1.add(this.speichern);
        this.restore = new Button("Zur\u00fccksetzen");
        this.restore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                switch (JOptionPane.showConfirmDialog(Settings.this.settings, "Konfiguration neu laden?", "Zur\u00fccksetzen", 2)) {
                    case 0: {
                        Settings.this.update_fields();
                    }
                }
            }
        });
        this.panel_1.add(this.restore);
        this.cancel = new Button("Abbrechen");
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Settings.this.update_fields();
                Settings.this.settings.setVisible(false);
            }
        });
        this.panel_1.add(this.cancel);
        this.speichern.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("Speichern")) {
                    switch (JOptionPane.showConfirmDialog(Settings.this.settings, "Konfiguration \u00fcbernehmen und speichern?")) {
                        case 0: {
                            Settings.this.update_config();
                            Config.saveConfig();
                            break;
                        }
                        case 1: {
                            break;
                        }
                        case 2: {
                            return;
                        }
                    }
                    Settings.this.update_fields();
                    Settings.this.settings.setVisible(false);
                }
            }
        });
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent e) {
                Settings.this.update_fields();
            }

            @Override
            public void windowIconified(WindowEvent e) {
                Settings.this.update_fields();
                Settings.this.settings.setVisible(false);
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
                Settings.this.update_fields();
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                Settings.this.update_fields();
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowActivated(WindowEvent e) {
                Settings.this.tabbedPane.setSelectedIndex(0);
                Settings.this.update_fields();
            }
        });
    }

    private void update_clients() {
        String query = "SELECT c000 AS name,c001 AS client,c003 AS city,c004 AS street,c006 AS plz,mesocomp,mesoyear,mesoprim FROM dbo.t001;";
        final int index = this.client_selected_index;
        new SimpleResultQuery(query, Tasks.VARIOUS, 10L){

            @Override
            public void failed(ResultSet result) {
                Logger.$("Mandanten konnten nicht gelesen werden.");
            }

            @Override
            public void completed(ResultSet result) {
                Settings.this.client_select.removeAllItems();
                try {
                    while (result.next()) {
                        Settings.this.client_select.addItem(result.getString("mesocomp"));
                    }
                }
                catch (SQLException e) {
                    Logger.$(e);
                }
                Settings.this.client_selected_index = index;
                Settings.this.client_select.setSelectedIndex(Settings.this.client_selected_index);
            }
        };
    }

    private void update_pictures() {
        Utils.updatePicturesList();
        this.bilder.removeAll();
        for (int i1 = 0; i1 < Utils.pictures.size(); ++i1) {
            this.bilder.add(Utils.pictures.get(i1));
        }
    }

    private void update_config() {
        Config.data.http_string(this.http_string_field.getText());
        Config.data.connection_string(this.connection_string_field.getText());
        Config.data.username(this.benutzer_field.getText());
        Config.data.password(this.password_field.getText());
        Config.data.meso_year(this.mesoyear_field.getText());
        Config.data.winline_query(this.sql_wl_zu_xtc.getText());
        Config.data.updates_query(this.sql_find_changed.getText());
        Config.data.verify_query(this.sql_update_local.getText());
        Config.data.stapelpreise_query("");
        Config.data.deletes_query(this.sql_find_deletes.getText());
        Config.data.inserts_query(this.sql_find_inserts.getText());
        Config.data.katalogs(this.katalog.getText());
        Config.data.auto_update(this.autoupdate.getState());
        Config.data.update_interval(this.upd_inverval_value.getText());
    }

    private void update_fields() {
        this.http_string_field.setText(Config.data.http_string());
        this.connection_string_field.setText(Config.data.connection_string());
        this.benutzer_field.setText(Config.data.username());
        this.password_field.setText(Config.data.password());
        this.mesoyear_field.setText(Config.data.meso_year());
        this.sql_wl_zu_xtc.setText(Config.data.winline_query());
        this.sql_find_changed.setText(Config.data.updates_query());
        this.sql_find_inserts.setText(Config.data.inserts_query());
        this.sql_find_deletes.setText(Config.data.deletes_query());
        this.sql_update_local.setText(Config.data.verify_query());
        this.katalog.setText(Config.data.katalog());
        this.autoupdate.setState(Config.data.auto_update());
        this.upd_inverval_value.setText(Integer.toString(Config.data.update_interval()));
        this.update_pictures();
    }
}

