/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.biene.gui;

import com.gmail.berndivader.biene.Logger;
import com.gmail.berndivader.biene.Utils;
import com.gmail.berndivader.biene.db.UpdateShopTask;
import com.gmail.berndivader.biene.db.ValidatePicture;
import com.gmail.berndivader.biene.gui.Settings;
import java.awt.AWTException;
import java.awt.Font;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.swing.BoxLayout;
import javax.swing.DropMode;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;

public class Main
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static boolean exit;
    public JPanel contentPane;
    public static Main frame;
    public static final String APP_NAME = "WinLine2Modified";
    public static Image icon_image;
    public Settings settings;
    public JTextArea log_area;
    public JScrollPane scrollBar;
    public TrayIcon tray_icon;
    public SystemTray tray;
    public PopupMenu popup;

    public static void init() {
        icon_image = Main.createImage("/appicon.gif", "blubb");
        new Main();
    }

    protected static Image createImage(String path, String description) {
        URL url = Main.class.getResource(path);
        if (url == null) {
            return new ImageIcon(new BufferedImage(32, 32, 2)).getImage();
        }
        return new ImageIcon(url, description).getImage();
    }

    public Main() {
        this.setDefaultCloseOperation(2);
        exit = false;
        this.setType(Window.Type.NORMAL);
        this.setFont(new Font("Tahoma", 0, 12));
        this.setTitle(APP_NAME);
        frame = this;
        this.setBounds(100, 100, 603, 560);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(new BoxLayout(this.contentPane, 0));
        this.addWindowStateListener(new WindowStateListener(){

            @Override
            public void windowStateChanged(WindowEvent e) {
                if (e.getNewState() == 1) {
                    frame.setVisible(false);
                }
            }
        });
        this.tray_icon = new TrayIcon(icon_image);
        frame.setIconImage(icon_image);
        this.tray = SystemTray.getSystemTray();
        try {
            this.tray.add(this.tray_icon);
        }
        catch (AWTException e) {
            Logger.$(e, false, true);
        }
        this.tray_icon.setPopupMenu(this.createPopup());
        this.log_area = new JTextArea();
        this.log_area.setDropMode(DropMode.INSERT);
        this.log_area.setFont(new Font("Monospaced", 0, 11));
        this.log_area.setEditable(false);
        this.log_area.setLineWrap(true);
        this.popup = this.createPopup();
        this.log_area.add(this.popup);
        this.contentPane.add(this.log_area);
        this.scrollBar = new JScrollPane(this.log_area);
        this.scrollBar.setHorizontalScrollBarPolicy(31);
        this.contentPane.add(this.scrollBar);
        this.tray_icon.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                int button = e.getButton();
                int count = e.getClickCount();
                if (button == 1 && count > 1) {
                    frame.setVisible(!frame.isVisible());
                    frame.setExtendedState(0);
                }
            }
        });
        this.log_area.setDropTarget(new DropTarget(this.log_area, new DropTargetListener(){

            @Override
            public void dragEnter(DropTargetDragEvent dtde) {
            }

            @Override
            public void dragOver(DropTargetDragEvent dtde) {
            }

            @Override
            public void dropActionChanged(DropTargetDragEvent dtde) {
            }

            @Override
            public void dragExit(DropTargetEvent dte) {
            }

            @Override
            public void drop(DropTargetDropEvent dtde) {
                if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    dtde.acceptDrop(1);
                    Transferable t = dtde.getTransferable();
                    try {
                        List files = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                        if (files != null) {
                            Utils.copyPictures(files);
                            for (int i1 = 0; files.size() > i1; ++i1) {
                                File file = (File)files.get(i1);
                                if (!file.getName().toLowerCase().endsWith(".jpg")) continue;
                                ValidatePicture valid = new ValidatePicture(file.getName());
                                valid.latch.await(30L, TimeUnit.SECONDS);
                                Logger.$(file.getName() + " wird bein n\u00e4chsten Update aktualisiert.");
                                if (valid.bool) continue;
                                Logger.$("Achtung! Dateiname konnte keinem Artikel zugeordnet werden.");
                            }
                        }
                    }
                    catch (UnsupportedFlavorException e) {
                        Logger.$(e);
                    }
                    catch (IOException e) {
                        Logger.$(e);
                    }
                    catch (InterruptedException e) {
                        Logger.$(e);
                    }
                }
            }
        }));
        this.log_area.addMouseListener(new MouseListener(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.showPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.showPopup(e);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            private void showPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    Main.this.popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        this.setVisible(false);
    }

    private PopupMenu createPopup() {
        PopupMenu popup = new PopupMenu();
        MenuItem popup_update = new MenuItem("Shop aktualisieren");
        MenuItem popup_show = new MenuItem("Toggle Window");
        MenuItem popup_about = new MenuItem("Info");
        MenuItem popup_settings = new MenuItem("Einstellungen");
        MenuItem popup_exit = new MenuItem("Beenden");
        popup.add(popup_update);
        popup.add(popup_about);
        popup.add(popup_settings);
        popup.add(popup_show);
        popup.add(popup_exit);
        popup_update.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new UpdateShopTask();
            }
        });
        popup_about.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Utils.showInfo();
            }
        });
        popup_show.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.setVisible(!frame.isVisible());
            }
        });
        popup_settings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Main.this.settings != null) {
                    Main.this.settings.setExtendedState(0);
                    Main.this.settings.setVisible(true);
                } else {
                    Main.this.settings = new Settings();
                    Main.this.settings.setVisible(true);
                    Main.this.settings.setExtendedState(0);
                }
            }
        });
        popup_exit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!exit) {
                    exit = true;
                    if (JOptionPane.showConfirmDialog(frame, "Biene wirklich beenden?", "Frage", 0) == 0) {
                        System.exit(0);
                    } else {
                        exit = false;
                    }
                }
            }
        });
        return popup;
    }
}

