/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.biene.http.get;

import com.gmail.berndivader.biene.Helper;
import com.gmail.berndivader.biene.Logger;
import com.gmail.berndivader.biene.Worker;
import com.gmail.berndivader.biene.config.Config;
import com.gmail.berndivader.biene.enums.Tasks;
import com.gmail.berndivader.biene.http.get.IGetTask;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.concurrent.FutureCallback;

public abstract class GetTask
extends Worker
implements Callable<HttpResponse>,
IGetTask {
    protected final String url;
    protected final Tasks command;
    protected final HttpGet request;
    public final CountDownLatch latch;
    public Future<HttpResponse> future;
    public boolean failed;

    public GetTask(String url, Tasks command) {
        if (!Helper.client.isRunning()) {
            Helper.client.start();
        }
        this.url = url;
        this.command = command;
        this.latch = new CountDownLatch(1);
        this.request = new HttpGet(url.concat(command.command()));
        if (Config.data.cf_enabled()) {
            this.request.setHeader("CF-Access-Client-Id", Config.data.cf_client());
            this.request.setHeader("CF-Access-Client-Secret", Config.data.cf_secret());
        }
        this.request.setHeader("X-Authorization", "Bearer ".concat(Config.data.bearer_token()));
        this.request.setHeader("user", Config.data.shop_user());
        this.request.setHeader("password", Config.data.shop_password());
        if (Helper.client.isRunning()) {
            this.future = Helper.executor.submit(this);
        } else {
            this.latch.countDown();
            Logger.$(this.request.getRequestLine() + " failed. http_client not running.", false, false);
        }
    }

    @Override
    public HttpResponse call() throws Exception {
        Future<HttpResponse> future = this.execute(this.request);
        try {
            return future.get(15L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            future.cancel(true);
            Logger.$("Task timeout.");
            return null;
        }
    }

    protected Future<HttpResponse> execute(HttpGet request) {
        return Helper.client.execute(request, new FutureCallback<HttpResponse>(){

            @Override
            public void failed(Exception e) {
                GetTask.this.failed = true;
                Logger.$(e, false, false);
                Logger.$(GetTask.this.command.action().concat(" failed."), false, false);
                GetTask.this.latch.countDown();
            }

            @Override
            public void completed(HttpResponse respond) {
                GetTask.this.failed = false;
                GetTask.this.latch.countDown();
            }

            @Override
            public void cancelled() {
                GetTask.this.failed = true;
                Logger.$(GetTask.this.command.action().concat(" cancelled."), false, false);
                GetTask.this.latch.countDown();
            }
        });
    }
}

