/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.biene.http.post;

import com.gmail.berndivader.biene.Helper;
import com.gmail.berndivader.biene.Logger;
import com.gmail.berndivader.biene.Worker;
import com.gmail.berndivader.biene.config.Config;
import com.gmail.berndivader.biene.enums.Tasks;
import com.gmail.berndivader.biene.http.post.IPostTask;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;

public abstract class PostTaskSync
extends Worker
implements Callable<HttpResponse>,
IPostTask {
    protected String url;
    protected HttpEntity entity;
    protected CompletableFuture<Void> completable;
    protected final HttpPost post;
    protected final Tasks command;
    public boolean failed = false;

    public PostTaskSync(String url) {
        this(url, null);
    }

    public PostTaskSync(String url, HttpEntity entity) {
        this.url = url;
        this.entity = entity;
        this.command = Tasks.VARIOUS;
        this.post = new HttpPost(url);
        if (Config.data.cf_enabled()) {
            this.post.setHeader("CF-Access-Client-Id", Config.data.cf_client());
            this.post.setHeader("CF-Access-Client-Secret", Config.data.cf_secret());
        }
        this.post.setHeader("X-Authorization", "Bearer ".concat(Config.data.bearer_token()));
        this.post.setHeader("user", Config.data.shop_user());
        this.post.setHeader("password", Config.data.shop_password());
        if (entity != null) {
            this.post.setEntity(this.entity);
        }
    }

    protected CompletableFuture<HttpResponse> start() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.call();
            }
            catch (Exception e) {
                this.failed = true;
                Logger.$(e);
                return Helper.errorResponse(e);
            }
        }, Helper.executor).orTimeout(this.max_seconds, TimeUnit.SECONDS);
    }

    @Override
    public HttpResponse call() throws Exception {
        CloseableHttpResponse response = Helper.syncClient.execute(this.post);
        int raw = response.getStatusLine().getStatusCode();
        if (raw > 199 && 300 > raw) {
            return response;
        }
        throw new RuntimeException(String.format("%s : %d - %s", this.command.action(), raw, response.getStatusLine().getReasonPhrase()));
    }

    public boolean isDone() {
        return this.completable.isDone();
    }

    public boolean isCancelled() {
        return this.completable.isCancelled();
    }

    public boolean isDoneExceptionally() {
        return this.completable.isCompletedExceptionally();
    }

    public boolean join() {
        try {
            this.completable.join();
            return !this.completable.isCancelled() && !this.completable.isCompletedExceptionally();
        }
        catch (Exception e) {
            return false;
        }
    }
}

