/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.biene.http.post;

import com.gmail.berndivader.biene.Logger;
import com.gmail.berndivader.biene.Utils;
import com.gmail.berndivader.biene.config.Config;
import com.gmail.berndivader.biene.enums.ActionEnum;
import com.gmail.berndivader.biene.http.post.PostTask;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpResponse;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.StringBody;
import org.w3c.dom.Document;

public class PostValidateImageFile
extends PostTask {
    String name;

    public PostValidateImageFile(String url, String image_name) {
        super(url);
        if (((String)image_name).toLowerCase().contains(".jpg")) {
            image_name = ((String)image_name).substring(0, ((String)image_name).length() - 4) + ".jpg";
        }
        this.name = image_name;
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        builder.addPart("image_name", new StringBody((String)image_name, ContentType.MULTIPART_FORM_DATA));
        builder.addPart("user", new StringBody(Config.data.getShopUser(), ContentType.MULTIPART_FORM_DATA));
        builder.addPart("password", new StringBody(Config.data.getShopPassword(), ContentType.MULTIPART_FORM_DATA));
        builder.addPart("action", new StringBody(ActionEnum.IMAGE_VALIDATE_FILE.action(), ContentType.MULTIPART_FORM_DATA));
        this.post.setEntity(builder.build());
        this.start();
    }

    @Override
    public void _completed(HttpResponse response) {
        Document xml = Utils.getXMLDocument(response);
        if (xml != null) {
            Map<String, String> result = PostValidateImageFile.mapNodes("", xml.getChildNodes(), new HashMap<String, String>());
            if (result.get("CODE").equals("-1")) {
                Logger.$("Achtung! Keine Bild-Datei " + this.name + " am Server gefunden.", false, false);
            }
        } else {
            Logger.$("Validate-Image-File hat ungew\u00f6hnlich geantwortet.", false, true);
        }
    }

    @Override
    public void _failed(HttpResponse response) {
    }
}

