/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.biene;

import com.gmail.berndivader.biene.Logger;
import com.gmail.berndivader.biene.Utils;
import com.gmail.berndivader.biene.config.Config;
import com.gmail.berndivader.biene.db.QueryBatchTask;
import com.gmail.berndivader.biene.db.UpdateShopTask;
import java.util.Stack;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class Batcher
extends Thread
implements Runnable {
    public static Stack<QueryBatchTask> query_stack = new Stack();
    QueryBatchTask current;
    public long update_start;
    public boolean auto_update = Config.data.getAutoUpdate();

    public Batcher() {
        this.update_start = Config.data.getUpdateInterval();
    }

    @Override
    public void run() {
        if (!query_stack.empty() && (this.current = query_stack.pop()) != null) {
            this.current.batch();
        }
        long startTime = Utils.getCurrentTimeMinutes();
        while (!this.isInterrupted()) {
            long elapsedTime;
            if (this.auto_update && (elapsedTime = Utils.getCurrentTimeMinutes() - startTime) >= this.update_start) {
                startTime = Utils.getCurrentTimeMinutes();
                new UpdateShopTask(Config.data.getWinlineQuery());
            }
            if (this.current != null && !this.current.future.isDone() && !this.current.future.isCancelled() && this.current.getRunningTime() / 60000L > 1L) {
                try {
                    this.current.future.get(1L, TimeUnit.SECONDS);
                }
                catch (InterruptedException | ExecutionException | TimeoutException e) {
                    Logger.$("Cancelled task ".concat(this.current.getClass().getName()).concat(" because of timeout."), false);
                    this.current.future.cancel(false);
                }
            }
            if ((this.current == null || this.current.future.isDone() || this.current.future.isCancelled()) && !query_stack.empty() && (this.current = query_stack.pop()) != null) {
                this.current.batch();
            }
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                Logger.$(e, false, true);
            }
        }
    }
}

