/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.biene;

import com.gmail.berndivader.biene.Biene;
import com.gmail.berndivader.biene.Headless;
import com.gmail.berndivader.biene.Logger;
import com.gmail.berndivader.biene.config.Config;
import com.gmail.berndivader.biene.db.SteuercodeQuery;
import com.gmail.berndivader.biene.db.ValidatePictureTask;
import com.gmail.berndivader.biene.enums.Action;
import com.gmail.berndivader.biene.enums.Tasks;
import com.gmail.berndivader.biene.http.Helper;
import com.gmail.berndivader.biene.http.get.GetInfo;
import com.gmail.berndivader.biene.http.post.PostSimple;
import com.gmail.berndivader.biene.rtf2html.RtfHtml;
import com.gmail.berndivader.biene.rtf2html.RtfReader;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.http.HttpResponse;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.util.EntityUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Utils {
    private static File lock_file;
    private static FileChannel lock_fileChannel;
    private static FileLock lock;
    private static boolean running;
    private static Calendar calendar;
    private static SimpleDateFormat date_format;
    private static DecimalFormat format;
    private static String key;
    public static List<String> pictures;
    public static final Gson GSON;
    public static File working_dir;

    public static void init() {
        File path = new File(working_dir + "/Bilder");
        if (!path.mkdirs() && !path.exists()) {
            Logger.$("Bilder Verzeichnis existiert nicht und konnte nicht erstellt werden.", false, true);
        }
    }

    public static boolean checkForInstance() throws IOException {
        lock_file = new File(working_dir + "/biene.lock");
        if (!lock_file.exists()) {
            lock_file.createNewFile();
        } else {
            lock_file.delete();
        }
        lock_fileChannel = new RandomAccessFile(lock_file, "rw").getChannel();
        lock = lock_fileChannel.tryLock();
        ShutdownHook shutdownHook = new ShutdownHook();
        Runtime.getRuntime().addShutdownHook(shutdownHook);
        if (lock == null) {
            lock_fileChannel.close();
            return true;
        }
        return running;
    }

    public static void unlockFile() {
        try {
            if (lock != null) {
                lock.release();
            }
            lock_fileChannel.close();
            lock_file.delete();
            running = false;
        }
        catch (IOException e) {
            Logger.$(e);
        }
    }

    public static String encrypt(String strClearText) {
        String strData = "";
        try {
            SecretKeySpec skeyspec = new SecretKeySpec(key.getBytes(), "Blowfish");
            Cipher cipher = Cipher.getInstance("Blowfish");
            cipher.init(1, skeyspec);
            byte[] encrypted = cipher.doFinal(strClearText.getBytes());
            strData = new String(Base64.getEncoder().encode(encrypted));
        }
        catch (Exception e) {
            Logger.$(e, false, true);
        }
        return strData;
    }

    public static String decrypt(String strEncrypted) {
        String strData = "";
        try {
            SecretKeySpec skeyspec = new SecretKeySpec(key.getBytes(), "Blowfish");
            Cipher cipher = Cipher.getInstance("Blowfish");
            cipher.init(2, skeyspec);
            byte[] decrypted = cipher.doFinal(Base64.getDecoder().decode(strEncrypted));
            strData = new String(decrypted);
        }
        catch (Exception e) {
            Logger.$(e, false, true);
        }
        return strData;
    }

    public static void writeLog(String log) {
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        builder.addPart("user", new StringBody(Config.data.getShopUser(), ContentType.MULTIPART_FORM_DATA));
        builder.addPart("password", new StringBody(Config.data.getShopPassword(), ContentType.MULTIPART_FORM_DATA));
        builder.addPart("action", new StringBody("log", ContentType.MULTIPART_FORM_DATA));
        builder.addPart("message", new StringBody("(" + date_format.format(calendar.getTime()) + ") " + log, ContentType.MULTIPART_FORM_DATA));
        new PostSimple(Config.data.getHttp_string(), builder.build());
    }

    public static void showInfo() {
        Logger.$("SQL-Server: " + Config.data.getConnection_string(), false, true);
        new GetInfo();
    }

    public static String makeCSVLine(Action action_enum, ResultSet result, RtfReader rtf_reader, RtfHtml rtf_html) {
        String delimiter = "|";
        String action = action_enum.value();
        StringBuilder line = new StringBuilder("XTSOL" + delimiter + action + delimiter);
        try {
            line.append(result.getString("p_model"));
            line.append(delimiter);
            line.append(Integer.toString(result.getInt("c008") - result.getInt("c009")));
            line.append(delimiter);
            line.append(delimiter);
            line.append(action_enum == Action.INSERT ? "1" : "");
            line.append(delimiter);
            line.append(delimiter);
            line.append(delimiter);
            line.append(result.getInt("p_web") == 40 ? "1" : "0");
            line.append(delimiter);
            line.append(format.format(result.getFloat("c007")));
            line.append(delimiter);
            line.append("||||||");
            line.append("1|1|1|1|1|1|1|");
            int tax = result.getInt("c030");
            if (tax == 1) {
                tax = 2;
            } else if (tax == 2) {
                tax = 1;
            } else {
                SteuercodeQuery query = new SteuercodeQuery(tax);
                try {
                    query.latch.await();
                    tax = query.code;
                }
                catch (InterruptedException e) {
                    Logger.$(e, false, true);
                    tax = 1;
                }
            }
            line.append(Integer.toString(tax));
            line.append(delimiter);
            line.append(action_enum == Action.INSERT ? "1" : "");
            line.append(delimiter);
            line.append(format.format(result.getFloat("c063")));
            line.append(delimiter);
            String tmp = result.getString("c075");
            if (tmp == null) {
                tmp = "";
            }
            line.append(tmp);
            line.append(delimiter);
            line.append("0.00");
            line.append(delimiter);
            line.append(delimiter);
            line.append("0");
            line.append(delimiter);
            line.append("0.0000");
            line.append(delimiter);
            line.append(delimiter);
            line.append(delimiter);
            line.append(delimiter);
            Object image_name = result.getString("c076");
            if (image_name != null && ((String)image_name).length() > 0) {
                if (((String)image_name).toLowerCase().contains(".jpg")) {
                    image_name = ((String)image_name).substring(0, ((String)image_name).length() - 4) + ".jpg";
                }
                line.append((String)image_name);
            } else {
                line.append("noimage.gif");
            }
            line.append(delimiter);
            line.append("||||||||");
            tmp = result.getString("c003");
            if (tmp == null) {
                tmp = "";
            }
            line.append(tmp);
            line.append(delimiter);
            try {
                String temp = result.getString("c080");
                if (temp == null) {
                    temp = "";
                }
                if (rtf_reader.isValid(temp)) {
                    rtf_reader.parse(temp);
                    line.append(rtf_html.format(rtf_reader.root, false));
                } else {
                    line.append(temp);
                }
            }
            catch (Exception e) {
                Logger.$(e, false, true);
            }
            line.append(delimiter);
            tmp = result.getString("c073");
            if (tmp == null) {
                tmp = "";
            }
            line.append(tmp);
            line.append(delimiter);
            line.append(delimiter);
            line.append(delimiter);
            line.append(delimiter);
            line.append(delimiter);
            line.append(delimiter);
            int id = result.getInt("p_web");
            AbstractMap.SimpleEntry<String, String> entry = Config.data.getKatalogs(id);
            line.append(entry.getValue());
            line.append(delimiter);
            line.append(entry.getKey());
        }
        catch (SQLException ex) {
            Logger.$(ex.getMessage(), false, true);
            Logger.$(ex);
        }
        line.append("\n");
        return line.toString();
    }

    public static File create_csv_file(String csv_string) {
        String file_name = UUID.randomUUID().toString() + ".csv";
        File file = new File(file_name);
        if (!file.exists()) {
            try {
                file.createNewFile();
                file.deleteOnExit();
                Utils.writeCSVFIle(file, csv_string);
            }
            catch (IOException e) {
                Logger.$(e, false, true);
            }
        }
        return file;
    }

    private static void writeCSVFIle(File file, String csv_string) throws IOException {
        try (FileWriter writer = new FileWriter(file);){
            writer.write(csv_string);
        }
    }

    public static void deleteCSVFile(String file_name) {
        File file = new File(file_name);
        if (file.exists()) {
            file.delete();
        }
    }

    public static void copyPictures(List<File> files) {
        int size = files.size();
        for (int i1 = 0; i1 < size; ++i1) {
            File file = files.get(i1);
            try {
                if (!file.getName().toLowerCase().endsWith(".jpg")) continue;
                String name = file.getName().substring(0, file.getName().length() - 4) + ".jpg";
                Files.copy(file.toPath(), new File(working_dir + "/Bilder/" + name).toPath(), StandardCopyOption.REPLACE_EXISTING);
                continue;
            }
            catch (IOException e) {
                Logger.$(e, false, false);
            }
        }
    }

    public static void updatePicturesList() {
        pictures = new ArrayList<String>();
        File[] files = null;
        files = Utils.getPictures();
        int size = files.length;
        for (int i1 = 0; i1 < size; ++i1) {
            pictures.add(files[i1].getName());
        }
        Collections.sort(pictures);
    }

    public static void validatePictures() {
        for (File file : Utils.getPictures()) {
            String file_name = file.getName();
            if (file_name.toUpperCase().contains(".JPG")) {
                String name = file_name.substring(0, file_name.length() - 4);
                String query = "select c076 from dbo.biene_temp where c076='" + name + "'";
                new ValidatePictureTask(query, Tasks.DB_VALIDATE_PICTURE, null);
                continue;
            }
            file.delete();
        }
    }

    public static File[] getPictures() {
        File folder = new File(working_dir + "/Bilder");
        folder.mkdir();
        return folder.listFiles();
    }

    public static String getStringFromResponse(HttpResponse response) {
        try {
            return EntityUtils.toString(response.getEntity());
        }
        catch (IOException | UnsupportedOperationException e) {
            Logger.$(e);
            return null;
        }
    }

    public static void deleteSelectedPictures(String[] selected_names) {
        int size = selected_names.length;
        if (size > 0) {
            // empty if block
        }
    }

    public static long getCurrentTimeMinutes() {
        return System.currentTimeMillis() / 1000L / 60L;
    }

    static {
        running = false;
        GSON = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
        calendar = Calendar.getInstance();
        date_format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        key = "01234567";
        format = new DecimalFormat("0.0000", DecimalFormatSymbols.getInstance(Locale.US));
        try {
            URI uri = Biene.class.getProtectionDomain().getCodeSource().getLocation().toURI();
            working_dir = new File(uri.getPath().replace(new File(uri).getName(), ""));
        }
        catch (URISyntaxException ex) {
            Logger.$(ex);
        }
        Utils.updatePicturesList();
    }

    private static class ShutdownHook
    extends Thread {
        private ShutdownHook() {
        }

        @Override
        public void run() {
            if (Biene.no_gui) {
                Headless.exit = true;
            }
            Logger.$("Biene wird beendet.", false);
            Utils.unlockFile();
            Helper.close();
            if (Biene.batcher != null) {
                Biene.batcher.interrupt();
            }
        }
    }

    public static class XML {
        public static Document getXMLDocument(HttpResponse response) {
            Document document;
            block8: {
                InputStream stream = response.getEntity().getContent();
                try {
                    document = XML.loadXMLFromStream(stream);
                    if (stream == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException | UnsupportedOperationException e) {
                        Logger.$(e, false, true);
                        return null;
                    }
                }
                stream.close();
            }
            return document;
        }

        public static void printOut(String parent, NodeList nodes) {
            int size = nodes.getLength();
            for (int i1 = 0; i1 < size; ++i1) {
                String text;
                Node node = nodes.item(i1);
                if (node.hasChildNodes()) {
                    XML.printOut((String)(parent.isEmpty() ? node.getNodeName() : parent + "." + node.getNodeName()), node.getChildNodes());
                    continue;
                }
                if (node.getNodeType() != 3 || (text = node.getTextContent().trim()).isEmpty()) continue;
                Logger.$(parent + ":" + text, false, false);
            }
        }

        public static Document loadXMLFromStream(InputStream is) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(true);
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document xml = builder.parse(is);
                return xml;
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                Logger.$(e, false, true);
                return null;
            }
        }

        public static String convertDocumentToString(Document doc) {
            try {
                TransformerFactory tf = TransformerFactory.newInstance();
                Transformer transformer = tf.newTransformer();
                StringWriter writer = new StringWriter();
                transformer.transform(new DOMSource(doc), new StreamResult(writer));
                return writer.getBuffer().toString();
            }
            catch (TransformerException e) {
                Logger.$(e);
                return null;
            }
        }
    }
}

