/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.biene;

import com.gmail.berndivader.biene.Biene;
import com.gmail.berndivader.biene.Helper;
import com.gmail.berndivader.biene.Logger;
import com.gmail.berndivader.biene.Utils;
import com.gmail.berndivader.biene.config.Config;
import com.gmail.berndivader.biene.db.QueryBatchTask;
import com.gmail.berndivader.biene.db.UpdateShopTask;
import com.gmail.berndivader.biene.gui.Main;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class Batcher
implements Runnable {
    public static final ConcurrentLinkedQueue<QueryBatchTask> QUERY_STACK = new ConcurrentLinkedQueue();
    public long update_start;
    public boolean auto_update = Config.data.auto_update();
    private long startTime;
    private int active_threads = -1;
    private int scheduled_threads = -1;
    private QueryBatchTask current;

    public Batcher() {
        this.update_start = Config.data.update_interval();
        if (!QUERY_STACK.isEmpty() && (this.current = QUERY_STACK.poll()) != null) {
            this.current.batch();
        }
        this.startTime = Utils.getCurrentTimeMinutes();
        Helper.scheduler.scheduleAtFixedRate(this, 0L, 200L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void run() {
        long elapsedTime;
        if (Helper.scheduler.isShutdown()) {
            return;
        }
        if (this.auto_update && (elapsedTime = Utils.getCurrentTimeMinutes() - this.startTime) >= this.update_start) {
            this.startTime = Utils.getCurrentTimeMinutes();
            new UpdateShopTask();
        }
        if (this.current != null && (double)this.current.getRunningTime() * 0.001 > (double)this.current.max_seconds && !this.current.future.isDone() && !this.current.future.isCancelled()) {
            try {
                this.current.future.get(3L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                Logger.$("Cancelled task ".concat(this.current.getClass().getName()).concat(" because of timeout."), false);
                this.current.future.cancel(false);
            }
        }
        if ((this.current == null || this.current.future.isDone() || this.current.future.isCancelled()) && !QUERY_STACK.isEmpty() && (this.current = QUERY_STACK.poll()) != null) {
            this.current.batch();
        }
        if (!(Biene.no_gui || Helper.executor.getActiveCount() == this.active_threads && QUERY_STACK.size() == this.scheduled_threads)) {
            this.active_threads = Helper.executor.getActiveCount();
            this.scheduled_threads = QUERY_STACK.size();
            Main.instance.setTitle("WinLine2Modified".concat(String.format(" [active:%s][queried:%s]", Integer.toString(this.active_threads), Integer.toString(this.scheduled_threads))));
        }
    }
}

