/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.interactions.component;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.dv8tion.jda.api.entities.channel.ChannelType;
import net.dv8tion.jda.api.interactions.components.Component;
import net.dv8tion.jda.api.interactions.components.selections.EntitySelectMenu;
import net.dv8tion.jda.api.utils.data.DataArray;
import net.dv8tion.jda.api.utils.data.DataObject;
import net.dv8tion.jda.internal.interactions.component.SelectMenuImpl;
import net.dv8tion.jda.internal.utils.Helpers;
import org.jetbrains.annotations.NotNull;

public class EntitySelectMenuImpl
extends SelectMenuImpl
implements EntitySelectMenu {
    protected final Component.Type type;
    protected final EnumSet<ChannelType> channelTypes;
    protected final List<EntitySelectMenu.DefaultValue> defaultValues;

    public EntitySelectMenuImpl(DataObject data) {
        super(data);
        this.type = Component.Type.fromKey(data.getInt("type"));
        this.channelTypes = Helpers.copyEnumSet(ChannelType.class, data.optArray("channel_types").map(arr -> arr.stream(DataArray::getInt).map(ChannelType::fromId).collect(Collectors.toList())).orElse(null));
        this.defaultValues = data.optArray("default_values").map(array -> array.stream(DataArray::getObject).map(EntitySelectMenu.DefaultValue::fromData).collect(Helpers.toUnmodifiableList())).orElse(Collections.emptyList());
    }

    public EntitySelectMenuImpl(String id, String placeholder, int minValues, int maxValues, boolean disabled, Component.Type type, EnumSet<ChannelType> channelTypes, List<EntitySelectMenu.DefaultValue> defaultValues) {
        super(id, placeholder, minValues, maxValues, disabled);
        this.type = type;
        this.channelTypes = channelTypes;
        this.defaultValues = defaultValues;
    }

    @Override
    @Nonnull
    public Component.Type getType() {
        return this.type;
    }

    @Override
    @Nonnull
    public EnumSet<EntitySelectMenu.SelectTarget> getEntityTypes() {
        switch (this.type) {
            case ROLE_SELECT: {
                return EnumSet.of(EntitySelectMenu.SelectTarget.ROLE);
            }
            case USER_SELECT: {
                return EnumSet.of(EntitySelectMenu.SelectTarget.USER);
            }
            case CHANNEL_SELECT: {
                return EnumSet.of(EntitySelectMenu.SelectTarget.CHANNEL);
            }
            case MENTIONABLE_SELECT: {
                return EnumSet.of(EntitySelectMenu.SelectTarget.ROLE, EntitySelectMenu.SelectTarget.USER);
            }
        }
        throw new IllegalStateException("Unsupported type: " + (Object)((Object)this.type));
    }

    @Override
    @Nonnull
    public EnumSet<ChannelType> getChannelTypes() {
        return this.channelTypes;
    }

    @Override
    @Nonnull
    public List<EntitySelectMenu.DefaultValue> getDefaultValues() {
        return this.defaultValues;
    }

    @Override
    @NotNull
    public DataObject toData() {
        DataObject json = super.toData().put("type", this.type.getKey());
        if (this.type == Component.Type.CHANNEL_SELECT && !this.channelTypes.isEmpty()) {
            json.put("channel_types", DataArray.fromCollection(this.channelTypes.stream().map(ChannelType::getId).collect(Collectors.toList())));
        }
        if (!this.defaultValues.isEmpty()) {
            json.put("default_values", DataArray.fromCollection(this.defaultValues));
        }
        return json;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.placeholder, this.minValues, this.maxValues, this.disabled, this.type, this.channelTypes, this.defaultValues});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof EntitySelectMenu)) {
            return false;
        }
        EntitySelectMenu other = (EntitySelectMenu)obj;
        return Objects.equals(this.id, other.getId()) && Objects.equals(this.placeholder, other.getPlaceholder()) && this.minValues == other.getMinValues() && this.maxValues == other.getMaxValues() && this.disabled == other.isDisabled() && this.type == other.getType() && this.channelTypes.equals(other.getChannelTypes()) && this.defaultValues.equals(other.getDefaultValues());
    }
}

