/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.heewhomee.consolecommand.commands;

import com.gmail.berndivader.heewhomee.Console;
import com.gmail.berndivader.heewhomee.HeeWhooMee;
import com.gmail.berndivader.heewhomee.Helper;
import com.gmail.berndivader.heewhomee.ai.BotSession;
import com.gmail.berndivader.heewhomee.annotations.ConsoleCommand;
import com.gmail.berndivader.heewhomee.consolecommand.Command;
import io.github.furstenheim.CopyDown;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@ConsoleCommand(name=".askai", usage="ask pandora bot a question")
public class AskAi
extends Command {
    private CopyDown converter = new CopyDown();
    private static BotSession botSession = new BotSession(HeeWhooMee.config.pandoraId);

    @Override
    protected void command(final String args2) {
        if (args2.isBlank() || !AskAi.botSession.useable) {
            if (args2.isBlank()) {
                Console.out("Blank questions are not allowed.");
            }
            if (!AskAi.botSession.useable) {
                Console.out("Bot is not useable.");
            }
            return;
        }
        Future<String> future = Helper.executor.submit(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return AskAi.this.getAiResult(args2);
            }
        });
        try {
            String answer = future.get(20L, TimeUnit.SECONDS);
            Console.out(answer);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            e.printStackTrace();
        }
    }

    private String getAiResult(String contentRaw) {
        String answer = "";
        try {
            answer = this.converter.convert(botSession.think(contentRaw));
        }
        catch (Exception e) {
            Console.err(e.getMessage(), true, e);
        }
        return answer;
    }
}

