/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.animatorstands;

import com.gmail.berndivader.animatorstands.AnimatorStands;
import com.gmail.berndivader.animatorstands.ArmorStandUtils;
import com.gmail.berndivader.animatorstands.MiFrame;
import com.google.gson.Gson;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.skills.Skill;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.skills.SkillMetadataImpl;
import io.lumine.mythic.core.skills.SkillTargeter;
import io.lumine.mythic.core.skills.SkillTriggers;
import io.lumine.mythic.core.skills.targeters.ConsoleTargeter;
import io.lumine.mythic.core.skills.targeters.IEntitySelector;
import io.lumine.mythic.core.skills.targeters.ILocationSelector;
import io.lumine.mythic.core.skills.targeters.OriginTargeter;
import io.lumine.mythic.core.skills.targeters.TriggerLocationTargeter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.EulerAngle;

public class ArmorStandAnimator {
    private static Map<String, Frame[]> animCache = new HashMap<String, Frame[]>();
    public static ConcurrentHashMap<UUID, ArmorStandAnimator> animators = new ConcurrentHashMap();
    private ArmorStand armorStand;
    private int length;
    private Frame[] frames;
    private boolean paused = false;
    private int currentFrame;
    private Location startLocation;
    private boolean interpolate = true;
    private boolean negated = false;
    private boolean autoInit = false;
    public String aiMobName;
    private File aniFile;
    public ActiveMob am;
    public ActiveMob aiMob;
    private double mcheck;
    private int lastaction;
    private boolean hasAI = false;
    public int AnimClock;
    public int currentAnimTick;
    public boolean isDying = false;
    public boolean usePL;

    public static void updateAll() {
        for (ArmorStandAnimator ani : animators.values()) {
            ani.update();
        }
    }

    public static Collection<ArmorStandAnimator> getAnimators() {
        return animators.values();
    }

    public static ArmorStandAnimator getAnimatorByUUID(UUID uuid) {
        if (animators.containsKey(uuid)) {
            return animators.get(uuid);
        }
        return null;
    }

    public static void clearCache() {
        animCache.clear();
    }

    public static String convertAnim(File file) {
        MiFrame miFrame = null;
        try (FileReader reader = new FileReader(file);){
            miFrame = (MiFrame)new Gson().fromJson((Reader)reader, MiFrame.class);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (miFrame != null) {
            return miFrame.toString();
        }
        return "";
    }

    private static void executeMythicMobsSkill(ArmorStandAnimator asa, String skillName) {
        if (asa.am == null) {
            return;
        }
        Optional<Object> maybeTargeter = Optional.empty();
        SkillMetadataImpl data = new SkillMetadataImpl(SkillTriggers.API, (SkillCaster)asa.am, asa.am.getEntity(), asa.am.getLocation(), null, null, 1.0f);
        String target = null;
        String sname = skillName.split(" ")[0];
        if (skillName.contains("@")) {
            String[] split = skillName.split("@");
            target = "@" + split[1].split(" ")[0];
            maybeTargeter = Optional.of(ArmorStandUtils.parseSkillTargeter(target));
        }
        if (maybeTargeter.isPresent()) {
            SkillTargeter targeter = (SkillTargeter)maybeTargeter.get();
            if (targeter instanceof IEntitySelector) {
                data.setEntityTargets(((IEntitySelector)targeter).getEntities((SkillMetadata)data));
                ((IEntitySelector)targeter).filter((SkillMetadata)data, false);
            }
            if (targeter instanceof ILocationSelector) {
                data.setLocationTargets(((ILocationSelector)targeter).getLocations((SkillMetadata)data));
                ((ILocationSelector)targeter).filter((SkillMetadata)data);
            } else if (targeter instanceof OriginTargeter) {
                data.setLocationTargets(((OriginTargeter)targeter).getLocations((SkillMetadata)data));
            } else if (targeter instanceof TriggerLocationTargeter) {
                HashSet<AbstractLocation> lTargets = new HashSet<AbstractLocation>();
                lTargets.add(data.getTrigger().getLocation());
                data.setLocationTargets(lTargets);
            }
            if (targeter instanceof ConsoleTargeter) {
                data.setEntityTargets(null);
                data.setLocationTargets(null);
            }
        } else if (asa.am.hasThreatTable()) {
            data.setEntityTarget(asa.am.getThreatTable().getTopThreatHolder());
        } else if (asa.am.getEntity().getTarget() != null) {
            data.setEntityTarget(asa.am.getEntity().getTarget());
        } else {
            data.setEntityTarget(asa.am.getEntity());
        }
        Optional maybeSkill = MythicBukkit.inst().getSkillManager().getSkill(sname);
        if (!maybeSkill.isPresent()) {
            return;
        }
        Skill skill = (Skill)maybeSkill.get();
        if (skill.isUsable((SkillMetadata)data, SkillTriggers.API)) {
            skill.execute((SkillMetadata)data);
        }
    }

    public static void doAI(ArmorStandAnimator asa) {
        ActiveMob aim = asa.aiMob;
        ActiveMob aam = asa.am;
        if (aam == null) {
            if (aim != null) {
                ArmorStandUtils.removeEntitySync(aim.getEntity().getBukkitEntity());
            }
            ArmorStandUtils.removeEntitySync((Entity)asa.getArmorStand());
            asa.remove();
            return;
        }
        if (aim == null) {
            aam.setDead();
            ArmorStandUtils.removeEntitySync((Entity)asa.getArmorStand());
            asa.remove();
            return;
        }
        LivingEntity entity = (LivingEntity)aim.getEntity().getBukkitEntity();
        if ((aim.isDead() || aam.isDead()) && !asa.isDying) {
            aim.setDead();
            ArmorStandUtils.removeEntitySync((Entity)asa.getArmorStand());
            asa.remove();
        } else {
            int check;
            if (!entity.hasPotionEffect(PotionEffectType.INVISIBILITY)) {
                ArmorStandUtils.applyInvisible(aim, 0L);
            }
            if ((check = ArmorStandAnimator.checkMovement(asa)) == 1) {
                aam.signalMob(aam.getEntity(), "MOVESTART");
            } else if (check == 2) {
                aam.signalMob(aam.getEntity(), "MOVESTOPP");
            }
            float y = aim.getEntity().getLocation().getYaw();
            float p = aim.getEntity().getLocation().getPitch();
            Location l = null;
            if (asa.lastaction == 2 && aim.hasTarget()) {
                if (aim.hasThreatTable()) {
                    if (aim.getThreatTable().size() > 0) {
                        l = ArmorStandUtils.lookAt(asa.armorStand.getLocation(), aim.getThreatTable().getTopThreatHolder().getBukkitEntity().getLocation());
                    } else {
                        ll = ArmorStandUtils.getTargetBlock(entity, 10);
                        if (ll != null) {
                            l = ArmorStandUtils.lookAt(asa.armorStand.getLocation(), ll);
                        }
                    }
                } else {
                    l = ArmorStandUtils.lookAt(asa.armorStand.getLocation(), aim.getEntity().getTarget().getBukkitEntity().getLocation());
                }
            } else {
                ll = ArmorStandUtils.getTargetBlock(entity, 10);
                if (ll != null) {
                    l = ArmorStandUtils.lookAt(asa.armorStand.getLocation(), ll);
                }
            }
            if (l != null) {
                y = l.getYaw();
                p = l.getPitch();
            }
            AbstractLocation location = aim.getLocation();
            ArmorStandUtils.nmsEntity.setLocation(aam.getEntity(), location.getX(), location.getY(), location.getZ(), y, p, false, false);
        }
    }

    public ArmorStandAnimator(File aniFile, ArmorStand armorStand, int animSpeed, Object oi, Object mobtype) {
        this.aniFile = aniFile;
        this.armorStand = armorStand;
        this.armorStand.setMetadata("asa", (MetadataValue)new FixedMetadataValue(AnimatorStands.inst(), (Object)true));
        this.AnimClock = animSpeed;
        this.currentAnimTick = 0;
        this.startLocation = armorStand.getLocation();
        if (oi != null) {
            this.autoInit = (Boolean)oi;
        }
        this.am = MythicBukkit.inst().getAPIHelper().getMythicMobInstance((Entity)armorStand);
        if (mobtype != null) {
            this.aiMobName = (String)mobtype;
            this.attachToAIMob();
        }
        this.loadFrames();
        animators.put(this.armorStand.getUniqueId(), this);
        ArmorStandAnimator.checkMovement(this);
    }

    public static int checkMovement(ArmorStandAnimator asa) {
        int action = 0;
        double chk = asa.armorStand.getLocation().getX() + asa.armorStand.getLocation().getY() + asa.armorStand.getLocation().getZ();
        if (chk != asa.mcheck) {
            if (asa.lastaction != 1) {
                action = 1;
                asa.lastaction = 1;
            }
            asa.mcheck = chk;
        } else if (asa.lastaction != 2) {
            action = 2;
            asa.lastaction = 2;
        }
        return action;
    }

    public void reAttachAIMob() {
        this.createAIMob();
    }

    public void attachToAIMob() {
        if (this.aiMob != null && !this.aiMob.isDead()) {
            return;
        }
        this.createAIMob();
    }

    private void createAIMob() {
        this.aiMob = MythicBukkit.inst().getMobManager().spawnMob(this.aiMobName, this.armorStand.getLocation());
        LivingEntity entity = (LivingEntity)this.aiMob.getEntity().getBukkitEntity();
        ArmorStandUtils.applyInvisible(this.aiMob, 5L);
        String ulow = this.armorStand.getUniqueId().toString().substring(0, this.armorStand.getUniqueId().toString().length() / 2);
        String uhigh = this.armorStand.getUniqueId().toString().substring(this.armorStand.getUniqueId().toString().length() / 2, this.armorStand.getUniqueId().toString().length());
        entity.setMetadata("aiMob", (MetadataValue)new FixedMetadataValue(AnimatorStands.inst(), (Object)ulow));
        entity.setMetadata("aiMob1", (MetadataValue)new FixedMetadataValue(AnimatorStands.inst(), (Object)uhigh));
        Bukkit.getScheduler().runTaskLater(AnimatorStands.inst(), new Runnable(){

            @Override
            public void run() {
                ActiveMob aim = ArmorStandAnimator.this.aiMob;
                if (aim != null) {
                    LivingEntity entity = (LivingEntity)aim.getEntity().getBukkitEntity();
                    entity.setCanPickupItems(false);
                }
            }
        }, 15L);
        this.hasAI = true;
    }

    public void changeAnim(File aniFile, int animSpeed) {
        this.stop();
        this.aniFile = aniFile;
        this.AnimClock = animSpeed;
        this.currentAnimTick = 0;
        this.loadFrames();
        this.play();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFrames() {
        if (animCache.containsKey(this.aniFile.getAbsolutePath())) {
            this.frames = new Frame[animCache.get(this.aniFile.getAbsolutePath()).length];
            this.frames = animCache.get(this.aniFile.getAbsolutePath());
            this.length = this.frames.length;
            this.currentFrame = 0;
            this.paused = false;
            this.negated = false;
        } else {
            BufferedReader br = null;
            try {
                br = this.aniFile.getName().endsWith("miframes") ? new BufferedReader(new StringReader(ArmorStandAnimator.convertAnim(this.aniFile))) : new BufferedReader(new FileReader(this.aniFile));
                String line = "";
                Frame currentFrame = null;
                while ((line = br.readLine()) != null) {
                    float z;
                    float y;
                    if (line.startsWith("length")) {
                        this.length = (int)Float.parseFloat(line.split(" ")[1]);
                        this.frames = new Frame[this.length];
                        continue;
                    }
                    if (line.startsWith("Animate_Negate")) {
                        this.negated = true;
                        continue;
                    }
                    if (line.startsWith("Animator_Auto_Init")) {
                        this.autoInit = true;
                        continue;
                    }
                    if (line.startsWith("frame")) {
                        if (currentFrame != null) {
                            this.frames[currentFrame.frameID] = currentFrame;
                        }
                        int frameID = Integer.parseInt(line.split(" ")[1]);
                        currentFrame = new Frame();
                        currentFrame.frameID = frameID;
                        continue;
                    }
                    if (line.contains("Armorstand_Position")) {
                        currentFrame.x = Float.parseFloat(line.split(" ")[1]);
                        currentFrame.y = Float.parseFloat(line.split(" ")[2]);
                        currentFrame.z = Float.parseFloat(line.split(" ")[3]);
                        currentFrame.r = Float.parseFloat(line.split(" ")[4]);
                        continue;
                    }
                    if (line.contains("Armorstand_Middle")) {
                        float x = (float)Math.toRadians(Float.parseFloat(line.split(" ")[1]));
                        y = (float)Math.toRadians(Float.parseFloat(line.split(" ")[2]));
                        z = (float)Math.toRadians(Float.parseFloat(line.split(" ")[3]));
                        if (this.negated) {
                            x = -x;
                            y = -y;
                            z = -z;
                        }
                        currentFrame.middle = new EulerAngle((double)x, (double)y, (double)z);
                        continue;
                    }
                    if (line.contains("Armorstand_Right_Leg")) {
                        float x = (float)Math.toRadians(Float.parseFloat(line.split(" ")[1]));
                        y = (float)Math.toRadians(Float.parseFloat(line.split(" ")[2]));
                        z = (float)Math.toRadians(Float.parseFloat(line.split(" ")[3]));
                        if (this.negated) {
                            x = -x;
                            y = -y;
                            z = -z;
                        }
                        currentFrame.rightLeg = new EulerAngle((double)x, (double)y, (double)z);
                        continue;
                    }
                    if (line.contains("Armorstand_Left_Leg")) {
                        float x = (float)Math.toRadians(Float.parseFloat(line.split(" ")[1]));
                        y = (float)Math.toRadians(Float.parseFloat(line.split(" ")[2]));
                        z = (float)Math.toRadians(Float.parseFloat(line.split(" ")[3]));
                        if (this.negated) {
                            x = -x;
                            y = -y;
                            z = -z;
                        }
                        currentFrame.leftLeg = new EulerAngle((double)x, (double)y, (double)z);
                        continue;
                    }
                    if (line.contains("Armorstand_Left_Arm")) {
                        float x = (float)Math.toRadians(Float.parseFloat(line.split(" ")[1]));
                        y = (float)Math.toRadians(Float.parseFloat(line.split(" ")[2]));
                        z = (float)Math.toRadians(Float.parseFloat(line.split(" ")[3]));
                        if (this.negated) {
                            x = -x;
                            y = -y;
                            z = -z;
                        }
                        currentFrame.leftArm = new EulerAngle((double)x, (double)y, (double)z);
                        continue;
                    }
                    if (line.contains("Armorstand_Right_Arm")) {
                        float x = (float)Math.toRadians(Float.parseFloat(line.split(" ")[1]));
                        y = (float)Math.toRadians(Float.parseFloat(line.split(" ")[2]));
                        z = (float)Math.toRadians(Float.parseFloat(line.split(" ")[3]));
                        if (this.negated) {
                            x = -x;
                            y = -y;
                            z = -z;
                        }
                        currentFrame.rightArm = new EulerAngle((double)x, (double)y, (double)z);
                        continue;
                    }
                    if (line.contains("Armorstand_Head")) {
                        float x = (float)Math.toRadians(Float.parseFloat(line.split(" ")[1]));
                        y = (float)Math.toRadians(Float.parseFloat(line.split(" ")[2]));
                        z = (float)Math.toRadians(Float.parseFloat(line.split(" ")[3]));
                        if (this.negated) {
                            x = -x;
                            y = -y;
                            z = -z;
                        }
                        currentFrame.head = new EulerAngle((double)x, (double)y, (double)z);
                        continue;
                    }
                    if (!line.contains("executeSkill")) continue;
                    currentFrame.doSkill = line.replaceFirst("executeSkill ", "");
                }
                if (currentFrame != null) {
                    this.frames[currentFrame.frameID] = currentFrame;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
            this.frames[0].autoInit = this.autoInit;
            this.frames[0].aiMobName = this.aiMobName;
            animCache.put(this.aniFile.getAbsolutePath(), this.frames);
        }
    }

    public boolean hasAI() {
        return this.hasAI;
    }

    public void remove() {
        animators.remove(this.armorStand.getUniqueId());
        if (this.aiMob != null && !this.aiMob.isDead()) {
            ArmorStandUtils.removeEntitySync(this.aiMob.getEntity().getBukkitEntity());
        }
    }

    public void pause() {
        this.paused = true;
    }

    public void stop() {
        this.currentFrame = 0;
        this.update();
        this.currentFrame = 0;
        this.paused = true;
    }

    public void play() {
        this.paused = false;
    }

    public void update() {
        if (!this.paused) {
            Frame f;
            if (this.currentFrame >= this.length - 1 || this.currentFrame < 0) {
                this.currentFrame = 0;
            }
            if ((f = this.frames[this.currentFrame]) == null) {
                f = this.interpolate(this.currentFrame);
            }
            if (f != null) {
                ArmorStand e = this.armorStand;
                if (e.getVehicle() == null) {
                    if (!this.hasAI) {
                        Location newLoc = this.startLocation.clone().add((double)f.x, (double)f.y, (double)f.z);
                        newLoc.setYaw(f.r + newLoc.getYaw());
                        newLoc.setPitch(e.getLocation().getPitch());
                        ArmorStandUtils.nmsEntity.setLocation(BukkitAdapter.adapt((Entity)e), newLoc.getX(), newLoc.getY(), newLoc.getZ(), newLoc.getYaw(), newLoc.getPitch());
                    }
                } else if (!this.hasAI) {
                    double xx = e.getVehicle().getLocation().getX();
                    double yy = e.getVehicle().getLocation().getY();
                    double zz = e.getVehicle().getLocation().getZ();
                    ArmorStandUtils.nmsEntity.setLocation(BukkitAdapter.adapt((Entity)e.getVehicle()), xx, yy, zz, e.getVehicle().getLocation().getYaw() + f.r, e.getVehicle().getLocation().getPitch());
                }
                this.armorStand.setBodyPose(f.middle);
                this.armorStand.setLeftLegPose(f.leftLeg);
                this.armorStand.setRightLegPose(f.rightLeg);
                this.armorStand.setLeftArmPose(f.leftArm);
                this.armorStand.setRightArmPose(f.rightArm);
                this.armorStand.setHeadPose(f.head);
                if (f.doSkill != null) {
                    ArmorStandAnimator.executeMythicMobsSkill(this, f.doSkill);
                }
                this.setStartLocation(e.getLocation());
            }
            ++this.currentFrame;
        }
    }

    public int getCurrentFrame() {
        return this.currentFrame;
    }

    public String checkForSkill() {
        return this.frames[this.currentFrame].doSkill;
    }

    public void setCurrentFrame(int currentFrame) {
        this.currentFrame = currentFrame;
    }

    public ArmorStand getArmorStand() {
        return this.armorStand;
    }

    public int getLength() {
        return this.length;
    }

    public Frame[] getFrames() {
        return this.frames;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public Location getStartLocation() {
        return this.startLocation;
    }

    public void setStartLocation(Location location) {
        this.startLocation = this.armorStand.getVehicle() == null ? location : this.armorStand.getVehicle().getLocation().clone();
    }

    public boolean isInterpolated() {
        return this.interpolate;
    }

    public void setInterpolated(boolean interpolate) {
        this.interpolate = interpolate;
    }

    private Frame interpolate(int frameID) {
        Frame minFrame = null;
        for (int i = frameID; i >= 0; --i) {
            if (this.frames[i] == null) continue;
            minFrame = this.frames[i];
            break;
        }
        Frame maxFrame = null;
        for (int i = frameID; i < this.frames.length; ++i) {
            if (this.frames[i] == null) continue;
            maxFrame = this.frames[i];
            break;
        }
        Frame res = null;
        if (maxFrame == null || minFrame == null) {
            if (maxFrame == null && minFrame != null) {
                return minFrame;
            }
            if (minFrame == null && maxFrame != null) {
                return maxFrame;
            }
            res = new Frame();
            res.frameID = frameID;
            return res;
        }
        res = new Frame();
        res.frameID = frameID;
        float Dmin = frameID - minFrame.frameID;
        float D = maxFrame.frameID - minFrame.frameID;
        float D0 = Dmin / D;
        res = minFrame.mult(1.0f - D0, frameID).add(maxFrame.mult(D0, frameID), frameID);
        return res;
    }

    public static class Frame {
        int frameID;
        String aiMobName;
        String doSkill;
        boolean autoInit;
        float x;
        float y;
        float z;
        float r;
        EulerAngle middle;
        EulerAngle rightLeg;
        EulerAngle leftLeg;
        EulerAngle rightArm;
        EulerAngle leftArm;
        EulerAngle head;

        public Frame mult(float a, int frameID) {
            Frame f = new Frame();
            f.frameID = frameID;
            f.x *= a;
            f.y *= a;
            f.z *= a;
            f.r *= a;
            f.middle = new EulerAngle(this.middle.getX() * (double)a, this.middle.getY() * (double)a, this.middle.getZ() * (double)a);
            f.rightLeg = new EulerAngle(this.rightLeg.getX() * (double)a, this.rightLeg.getY() * (double)a, this.rightLeg.getZ() * (double)a);
            f.leftLeg = new EulerAngle(this.leftLeg.getX() * (double)a, this.leftLeg.getY() * (double)a, this.leftLeg.getZ() * (double)a);
            f.rightArm = new EulerAngle(this.rightArm.getX() * (double)a, this.rightArm.getY() * (double)a, this.rightArm.getZ() * (double)a);
            f.leftArm = new EulerAngle(this.leftArm.getX() * (double)a, this.leftArm.getY() * (double)a, this.leftArm.getZ() * (double)a);
            f.head = new EulerAngle(this.head.getX() * (double)a, this.head.getY() * (double)a, this.head.getZ() * (double)a);
            return f;
        }

        public Frame add(Frame a, int frameID) {
            Frame f = new Frame();
            f.frameID = frameID;
            f.x += a.x;
            f.y += a.y;
            f.z += a.z;
            f.r += a.r;
            f.middle = new EulerAngle(this.middle.getX() + a.middle.getX(), this.middle.getY() + a.middle.getY(), this.middle.getZ() + a.middle.getZ());
            f.rightLeg = new EulerAngle(this.rightLeg.getX() + a.rightLeg.getX(), this.rightLeg.getY() + a.rightLeg.getY(), this.rightLeg.getZ() + a.rightLeg.getZ());
            f.leftLeg = new EulerAngle(this.leftLeg.getX() + a.leftLeg.getX(), this.leftLeg.getY() + a.leftLeg.getY(), this.leftLeg.getZ() + a.leftLeg.getZ());
            f.rightArm = new EulerAngle(this.rightArm.getX() + a.rightArm.getX(), this.rightArm.getY() + a.rightArm.getY(), this.rightArm.getZ() + a.rightArm.getZ());
            f.leftArm = new EulerAngle(this.leftArm.getX() + a.leftArm.getX(), this.leftArm.getY() + a.leftArm.getY(), this.leftArm.getZ() + a.leftArm.getZ());
            f.head = new EulerAngle(this.head.getX() + a.head.getX(), this.head.getY() + a.head.getY(), this.head.getZ() + a.head.getZ());
            return f;
        }
    }
}

