/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicdenizenaddon.cmds;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.queues.ScriptQueue;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.gmail.berndivader.mythicdenizenaddon.MythicMobsAddon;
import com.gmail.berndivader.mythicdenizenaddon.Utils;
import com.gmail.berndivader.mythicdenizenaddon.obj.dMythicMeta;
import com.gmail.berndivader.mythicdenizenaddon.obj.dMythicSkill;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.mobs.GenericCaster;
import io.lumine.xikage.mythicmobs.skills.SkillCaster;
import io.lumine.xikage.mythicmobs.skills.SkillManager;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.SkillTrigger;
import java.util.AbstractMap;
import java.util.HashSet;
import org.bukkit.Location;
import org.bukkit.entity.Entity;

public class ExecuteMythicMobsSkill
extends AbstractCommand {
    static SkillManager skillmanager = MythicMobsAddon.mythicmobs.getSkillManager();
    static String str_error = "ExecuteMythicMobsSkill - argument %s is required!";

    public void parseArgs(ScriptEntry entry) throws InvalidArgumentsException {
        for (Argument arg : entry.getProcessedArgs()) {
            if (!entry.hasObject("skill") && arg.matchesPrefix("skill")) {
                if (arg.matchesArgumentType(dMythicSkill.class)) {
                    entry.addObject("skill", (Object)arg.asType(dMythicSkill.class));
                    continue;
                }
                entry.addObject("skill", (Object)new dMythicSkill(arg.asElement().asString()));
                continue;
            }
            if (!entry.hasObject("data") && arg.matchesPrefix("data")) {
                if (!arg.matchesArgumentType(dMythicMeta.class)) continue;
                entry.addObject("data", (Object)arg.asType(dMythicMeta.class));
                continue;
            }
            if (!entry.hasObject("caster") && arg.matchesPrefix("caster")) {
                if (!arg.matchesArgumentType(EntityTag.class)) continue;
                entry.addObject("caster", (Object)arg.asType(EntityTag.class));
                continue;
            }
            if (!entry.hasObject("trigger") && arg.matchesPrefix("trigger")) {
                if (!arg.matchesArgumentType(EntityTag.class)) continue;
                entry.addObject("trigger", (Object)arg.asType(EntityTag.class));
                continue;
            }
            if (!entry.hasObject("origin") && arg.matchesPrefix("origin")) {
                if (!arg.matchesArgumentType(LocationTag.class)) continue;
                entry.addObject("origin", (Object)arg.asType(LocationTag.class));
                continue;
            }
            if (!entry.hasObject("cause") && arg.matchesPrefix("cause")) {
                entry.addObject("cause", (Object)arg.asElement());
                continue;
            }
            if (!entry.hasObject("power") && arg.matchesPrefix("power")) {
                if (!arg.matchesFloat()) continue;
                arg.asElement();
                continue;
            }
            if (entry.hasObject("targets") || !arg.matchesPrefix("targets")) continue;
            if (arg.matchesArgumentType(ListTag.class)) {
                entry.addObject("targets", (Object)arg.asType(ListTag.class));
                continue;
            }
            if (!arg.matchesArgumentType(EntityTag.class)) continue;
            ListTag list = new ListTag();
            list.addObject(arg.asType(EntityTag.class));
            entry.addObject("targets", (Object)list);
        }
        if (!entry.hasObject("skill")) {
            Debug.echoError((ScriptQueue)entry.getResidingQueue(), (String)String.format(str_error, "skill"));
        }
    }

    public void execute(ScriptEntry entry) {
        SkillMetadata meta = null;
        dMythicSkill dskill = (dMythicSkill)entry.getObjectTag("skill");
        if (entry.hasObject("data")) {
            meta = ((dMythicMeta)entry.getObjectTag("data")).getSkillMetadata();
        } else {
            GenericCaster caster = null;
            AbstractEntity trigger = null;
            AbstractLocation origin = null;
            SkillTrigger cause = SkillTrigger.API;
            float power = 1.0f;
            HashSet<Object> locations = new HashSet();
            HashSet<Object> entities = new HashSet();
            if (dskill.hasMeta()) {
                meta = dskill.getSkillMetadata();
            }
            EntityTag dentity_caster = (EntityTag)entry.getObjectTag("caster");
            EntityTag dentity_trigger = (EntityTag)entry.getObjectTag("trigger");
            LocationTag dlocation_origin = (LocationTag)entry.getObject("origin");
            ElementTag dcause = entry.getElement("cause");
            ElementTag dpower = entry.getElement("power");
            ListTag dtargets = (ListTag)entry.getObjectTag("targets");
            if (dentity_caster != null) {
                caster = new GenericCaster(BukkitAdapter.adapt((Entity)dentity_caster.getBukkitEntity()));
            }
            if (dentity_trigger != null) {
                trigger = BukkitAdapter.adapt((Entity)dentity_trigger.getBukkitEntity());
            }
            if (dlocation_origin != null) {
                origin = BukkitAdapter.adapt((Location)dlocation_origin);
            }
            if (dcause != null) {
                cause = Utils.enum_lookup(SkillTrigger.class, dcause.asString());
            }
            if (dpower != null) {
                power = dpower.asFloat();
            }
            if (dtargets != null) {
                AbstractMap.SimpleEntry<HashSet<AbstractEntity>, HashSet<AbstractLocation>> pair = Utils.split_target_list(dtargets);
                locations = pair.getValue();
                entities = pair.getKey();
            }
            if (meta == null) {
                meta = new SkillMetadata(cause, (SkillCaster)caster, trigger, origin, entities, locations, power);
            } else {
                if (caster != null) {
                    meta.setCaster((SkillCaster)caster);
                }
                if (trigger != null) {
                    meta.setTrigger(trigger);
                }
                if (origin != null) {
                    meta.setOrigin(origin);
                }
                if (!locations.isEmpty()) {
                    meta.setLocationTargets(locations);
                } else if (!entities.isEmpty()) {
                    meta.setEntityTargets(entities);
                }
            }
        }
        dskill.execute(meta);
    }
}

