/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicdenizenaddon.events;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.gmail.berndivader.mythicdenizenaddon.MythicDenizenPlugin;
import com.gmail.berndivader.mythicdenizenaddon.events.MMDenizenCustomSkill;
import com.gmail.berndivader.mythicdenizenaddon.obj.dMythicMeta;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class DenizenSkillEvent
extends BukkitScriptEvent
implements Listener {
    public static DenizenSkillEvent instance;
    public MMDenizenCustomSkill event;
    private ElementTag skill;
    private ElementTag args;
    private ElementTag targetType;
    private EntityTag caster;
    private EntityTag target;
    private EntityTag trigger;
    private LocationTag targetLoc;
    dMythicMeta data;

    public DenizenSkillEvent() {
        instance = this;
    }

    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        return path.eventLower.startsWith("mm denizen mechanic") || path.eventLower.startsWith("mythicmobs skill");
    }

    public boolean matches(ScriptEvent.ScriptPath path) {
        return super.matches(path);
    }

    public String getName() {
        return "MythicMobCustomMechanic";
    }

    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)MythicDenizenPlugin.inst());
    }

    public void destroy() {
        MMDenizenCustomSkill.getHandlerList().unregister((Listener)this);
    }

    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag tag) {
        if (DenizenSkillEvent.isDefaultDetermination((ObjectTag)tag)) {
            return Boolean.parseBoolean(tag.toString());
        }
        return super.applyDetermination(path, tag);
    }

    public ObjectTag getContext(String name) {
        switch (name.toLowerCase()) {
            case "skill": {
                return this.skill;
            }
            case "args": {
                return this.args;
            }
            case "caster": 
            case "entity": {
                return this.caster;
            }
            case "target": {
                return this.target;
            }
            case "targetlocation": {
                return this.targetLoc;
            }
            case "trigger": {
                return this.trigger;
            }
            case "targettype": {
                return this.targetType;
            }
            case "data": {
                return this.data;
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onMythicDenizenSkillEvent(MMDenizenCustomSkill e) {
        this.skill = new ElementTag(e.getSkill());
        this.args = new ElementTag(e.getArgs());
        this.caster = e.getCaster() != null ? new EntityTag(e.getCaster()) : null;
        this.target = e.getTargetEntity() != null ? new EntityTag(e.getTargetEntity()) : null;
        this.targetLoc = e.getTargetLocation() != null ? new LocationTag(e.getTargetLocation()) : null;
        this.targetType = new ElementTag(e.getTargetType());
        this.trigger = e.getTrigger() != null ? new EntityTag(e.getTrigger()) : null;
        this.data = new dMythicMeta(e.getMetadata());
        this.event = e;
        this.fire(e);
    }
}

