/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicdenizenaddon.events;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.gmail.berndivader.mythicdenizenaddon.MythicDenizenPlugin;
import com.gmail.berndivader.mythicdenizenaddon.obj.dActiveMob;
import io.lumine.xikage.mythicmobs.adapters.AbstractItemStack;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitItemStack;
import io.lumine.xikage.mythicmobs.api.bukkit.events.MythicMobLootDropEvent;
import io.lumine.xikage.mythicmobs.drops.Drop;
import io.lumine.xikage.mythicmobs.drops.DropMetadata;
import io.lumine.xikage.mythicmobs.drops.IIntangibleDrop;
import io.lumine.xikage.mythicmobs.drops.IItemDrop;
import io.lumine.xikage.mythicmobs.drops.ILocationDrop;
import io.lumine.xikage.mythicmobs.drops.IMessagingDrop;
import io.lumine.xikage.mythicmobs.drops.IMultiDrop;
import io.lumine.xikage.mythicmobs.drops.LootBag;
import io.lumine.xikage.mythicmobs.drops.droppables.ItemDrop;
import io.lumine.xikage.mythicmobs.skills.SkillCaster;
import java.util.ArrayList;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class MythicMobsDropEvent
extends BukkitScriptEvent
implements Listener {
    public static MythicMobsDropEvent instance;
    public MythicMobLootDropEvent e;
    private LootBag lootBag;

    public MythicMobsDropEvent() {
        instance = this;
    }

    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        return path.eventLower.contains("mm lootdrop") || path.eventLower.contains("mythicmobs lootdrop");
    }

    public boolean matches(ScriptEvent.ScriptPath path) {
        return this.couldMatch(path);
    }

    public String getName() {
        return "MythicMobLootDropEvent";
    }

    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)MythicDenizenPlugin.inst());
    }

    public void destroy() {
        MythicMobLootDropEvent.getHandlerList().unregister((Listener)this);
    }

    public ScriptEntryData getScriptEntryData() {
        EntityTag dropper = new EntityTag(this.e.getEntity());
        return new BukkitScriptEntryData(dropper.isPlayer() ? dropper.getDenizenPlayer() : null, dropper.isNPC() ? dropper.getDenizenNPC() : null);
    }

    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag tag) {
        if (MythicMobsDropEvent.isDefaultDetermination((ObjectTag)tag)) {
            String determination = tag.toString();
            if (Argument.valueOf((String)determination).matchesArgumentType(ListTag.class)) {
                MythicMobsDropEvent.setDrops(this.lootBag, (ListTag)Argument.valueOf((String)determination).asType(ListTag.class), this.e);
            }
            return true;
        }
        return super.applyDetermination(path, tag);
    }

    public ObjectTag getContext(String name) {
        switch (name.toLowerCase()) {
            case "drops": {
                return MythicMobsDropEvent.getDrops(this.e, this.lootBag);
            }
            case "money": {
                return new ElementTag(this.e.getMoney());
            }
            case "exp": {
                return new ElementTag(this.e.getExp());
            }
            case "activemob": {
                return new dActiveMob(this.e.getMob());
            }
            case "killer": {
                return new EntityTag((Entity)this.e.getKiller());
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onMythicMobLootDrop(MythicMobLootDropEvent ev) {
        this.e = ev;
        this.lootBag = ev.getDrops();
        this.fire((Event)this.e);
    }

    private static void setDrops(LootBag lootBag, ListTag dropList, MythicMobLootDropEvent e) {
        HashMap intangibleDrops = new HashMap();
        ArrayList<Object> itemDrops = new ArrayList<Object>();
        for (String type : dropList) {
            if (Argument.valueOf((String)type).matchesArgumentType(ItemTag.class)) {
                BukkitItemStack bit = (BukkitItemStack)BukkitAdapter.adapt((ItemStack)((ItemTag)Argument.valueOf((String)type).asType(ItemTag.class)).getItemStack());
                ItemDrop drop = new ItemDrop("MMDA", null, bit);
                drop.setAmount((double)bit.getAmount());
                itemDrops.add(drop);
                continue;
            }
            Drop drop = Drop.getDrop((String)"mmda_drop", (String)type);
            if (drop instanceof IMultiDrop) {
                LootBag loot = ((IMultiDrop)drop).get(new DropMetadata((SkillCaster)e.getMob(), BukkitAdapter.adapt((Entity)e.getKiller())));
                for (Drop d1 : loot.getDrops()) {
                    if (d1 instanceof IItemDrop) {
                        itemDrops.add(d1);
                        continue;
                    }
                    intangibleDrops.merge(d1.getClass(), d1, (o, n) -> o.addAmount(n));
                }
                continue;
            }
            String[] arr1 = type.split(" ");
            drop.setAmount(arr1.length == 1 ? 1.0 : Double.parseDouble(arr1[1]));
            intangibleDrops.merge(drop.getClass(), drop, (o, n) -> o.addAmount(n));
        }
        lootBag.setLootTable(itemDrops);
        lootBag.setLootTableIntangible(intangibleDrops);
    }

    private static ListTag getDrops(MythicMobLootDropEvent e, LootBag lootBag) {
        ListTag dropList = new ListTag();
        for (Drop drop : lootBag.getDrops()) {
            if (drop instanceof IItemDrop) {
                ItemStack item = BukkitAdapter.adapt((AbstractItemStack)((IItemDrop)drop).getDrop(new DropMetadata((SkillCaster)e.getMob(), BukkitAdapter.adapt((Entity)e.getKiller()))));
                dropList.add(new ItemTag(item).identify());
                continue;
            }
            if (!(drop instanceof ILocationDrop) && !(drop instanceof IIntangibleDrop) && !(drop instanceof IMessagingDrop)) continue;
            dropList.add(drop.getLine());
        }
        return dropList;
    }
}

