/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicdenizenaddon.obj;

import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizencore.objects.Adjustable;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.TagContext;
import com.gmail.berndivader.mythicdenizenaddon.MythicMobsAddon;
import com.gmail.berndivader.mythicdenizenaddon.obj.dActiveMob;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.AbstractWorld;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.spawning.spawners.MythicSpawner;
import io.lumine.xikage.mythicmobs.utils.numbers.RandomInt;

public class dMythicSpawner
implements ObjectTag,
Adjustable {
    static String id = "mythicspawner@";
    private String prefix;
    MythicSpawner ms;

    public dMythicSpawner(MythicSpawner mythicSpawner) {
        this.ms = mythicSpawner;
    }

    public static boolean matches(String string) {
        return dMythicSpawner.valueOf(string) != null;
    }

    public static dMythicSpawner valueOf(String name) {
        return dMythicSpawner.valueOf(name, null);
    }

    public void adjust(Mechanism m) {
        ElementTag val = m.getValue();
        switch (m.getName().toLowerCase()) {
            case "activate": {
                if (val.asBoolean()) {
                    this.ms.ActivateSpawner();
                    break;
                }
                this.ms.Disable();
                break;
            }
            case "remainingcooldown": {
                this.ms.setRemainingCooldownSeconds(val.asLong());
                break;
            }
            case "cooldown": {
                this.ms.setCooldownSeconds(val.asInt());
                break;
            }
            case "remainingwarmup": {
                this.ms.setRemainingWarmupSeconds(val.asLong());
                break;
            }
            case "warmup": {
                this.ms.setWarmupSeconds(val.asInt());
                break;
            }
            case "mobtype": {
                if (!MythicMobsAddon.isMythicMob(val.asString())) break;
                this.ms.setType(val.asString());
                break;
            }
            case "moblevel": {
                this.ms.setMobLevel(new RandomInt(val.asInt()));
                break;
            }
            case "spawn": {
                this.ms.Spawn();
                break;
            }
            case "attachmob": {
                MythicMobsAddon.attachMobToSpawner(this.ms, (dActiveMob)val.asType(dActiveMob.class, m.context));
            }
        }
    }

    public String getAttribute(Attribute a) {
        if (a == null) {
            return null;
        }
        if (a.startsWith("location")) {
            return new LocationTag(BukkitAdapter.adapt((AbstractLocation)this.ms.getLocation())).getAttribute(a.fulfill(1));
        }
        if (a.startsWith("world")) {
            return new WorldTag(BukkitAdapter.adapt((AbstractWorld)this.ms.getLocation().getWorld())).getAttribute(a.fulfill(1));
        }
        if (a.startsWith("allactivemobs")) {
            return MythicMobsAddon.getActiveMobsFromSpawner(this.ms).getAttribute(a.fulfill(1));
        }
        if (a.startsWith("mobtype")) {
            return new ElementTag(this.ms.getTypeName()).getAttribute(a.fulfill(1));
        }
        if (a.startsWith("moblevel")) {
            return new ElementTag(this.ms.getMobLevel().get()).getAttribute(a.fulfill(1));
        }
        if (a.startsWith("cooldown")) {
            return new ElementTag(this.ms.getCooldownSeconds()).getAttribute(a.fulfill(1));
        }
        if (a.startsWith("remainingcooldown")) {
            return new ElementTag(this.ms.getRemainingCooldownSeconds()).getAttribute(a.fulfill(1));
        }
        if (a.startsWith("warmup")) {
            return new ElementTag(this.ms.getWarmupSeconds()).getAttribute(a.fulfill(1));
        }
        if (a.startsWith("remainingwarmup")) {
            return new ElementTag(this.ms.getRemainingWarmupSeconds()).getAttribute(a.fulfill(1));
        }
        if (a.startsWith("mobamount")) {
            return new ElementTag(this.ms.getNumberOfMobs()).getAttribute(a.fulfill(1));
        }
        if (a.startsWith("maxmobamount")) {
            return new ElementTag(this.ms.getMaxMobs().get()).getAttribute(a.fulfill(1));
        }
        return new ElementTag(this.identify()).getAttribute(a);
    }

    public void applyProperty(Mechanism arg0) {
    }

    public String debug() {
        return this.prefix + "='<A>" + this.identify() + "<G>'";
    }

    public String getObjectType() {
        return "MythicSpawner";
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String identify() {
        return this.ms != null ? id + this.ms.getName() : null;
    }

    public String identifySimple() {
        return this.identify();
    }

    public boolean isUnique() {
        return true;
    }

    public ObjectTag setPrefix(String string) {
        this.prefix = string;
        return this;
    }

    public String toString() {
        return this.identify();
    }

    @Fetchable(value="mythicspawner")
    public static dMythicSpawner valueOf(String uniqueName, TagContext context) {
        if (uniqueName == null) {
            return null;
        }
        try {
            uniqueName = uniqueName.replace(id, "");
            if (!MythicMobsAddon.isMythicSpawner(uniqueName)) {
                return null;
            }
            return new dMythicSpawner(MythicMobsAddon.getMythicSpawner(uniqueName));
        }
        catch (Exception e) {
            return null;
        }
    }
}

