/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicmobsext.conditions;

import com.gmail.berndivader.mythicmobsext.conditions.AbstractCustomCondition;
import com.gmail.berndivader.mythicmobsext.externals.ExternalAnnotation;
import com.gmail.berndivader.mythicmobsext.utils.Utils;
import com.gmail.berndivader.mythicmobsext.utils.math.MathUtils;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.conditions.ILocationCondition;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

@ExternalAnnotation(name="behindnearestplayer", author="BerndiVader")
public class LocationBehindNearestPlayerCondition
extends AbstractCustomCondition
implements ILocationCondition {
    double viewAngle;
    double range;

    public LocationBehindNearestPlayerCondition(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.viewAngle = MathUtils.round(mlc.getDouble(new String[]{"view", "angle", "v"}, 45.0), 3);
        this.range = Math.pow(mlc.getDouble("range", 32.0), 2.0);
    }

    public boolean check(AbstractLocation arg0) {
        Location source = BukkitAdapter.adapt((AbstractLocation)arg0);
        List<Player> players = Utils.getPlayersInRange(source, this.range);
        int size = players.size();
        Double nearest_distance = null;
        Location nearest_location = null;
        for (int i1 = 0; i1 < size; ++i1) {
            Location l = players.get(i1).getLocation().clone();
            if (nearest_distance == null) {
                nearest_distance = Math.abs(l.distanceSquared(source));
                nearest_location = l.clone();
                continue;
            }
            double check_distance = Math.abs(l.distanceSquared(source));
            if (!(check_distance < nearest_distance)) continue;
            nearest_distance = check_distance;
            nearest_location = l.clone();
        }
        if (nearest_location != null) {
            return LocationBehindNearestPlayerCondition.check(nearest_location, source, this.viewAngle);
        }
        return false;
    }

    private static boolean check(Location s, Location t, double viewAngle) {
        Vector r;
        double dT = Math.cos(viewAngle);
        Vector f = s.getDirection();
        return Math.toDegrees(Math.asin(f.dot(r = s.subtract(t).toVector().normalize()))) >= dT;
    }
}

