/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicmobsext.mechanics;

import com.gmail.berndivader.mythicmobsext.NMS.NMSUtils;
import com.gmail.berndivader.mythicmobsext.externals.ExternalAnnotation;
import com.gmail.berndivader.mythicmobsext.items.HoldingItem;
import com.gmail.berndivader.mythicmobsext.utils.Utils;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.items.ItemManager;
import io.lumine.xikage.mythicmobs.skills.AbstractSkill;
import io.lumine.xikage.mythicmobs.skills.INoTargetSkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.placeholders.PlaceholderMeta;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderInt;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderString;
import java.util.Optional;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;

@ExternalAnnotation(name="giveitem", author="BerndiVader")
public class CreateItem
extends SkillMechanic
implements ITargetedEntitySkill,
INoTargetSkill {
    static ItemManager itemmanager = Utils.mythicmobs.getItemManager();
    public static final String str_viewonly = "view_only";
    PlaceholderString bag_name;
    PlaceholderString item_name;
    String click_skill;
    HoldingItem holding;
    boolean override;
    Optional<Boolean> view_only = Optional.empty();
    PlaceholderInt amount;

    public CreateItem(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.threadSafetyLevel = AbstractSkill.ThreadSafetyLevel.SYNC_ONLY;
        this.holding = new HoldingItem();
        this.holding.setWhere(mlc.getString("to", "inventory"));
        this.holding.setSlot(mlc.getString("slot", "-1"));
        this.holding.setBagName(mlc.getString("bagname"));
        this.item_name = PlaceholderString.of((String)mlc.getString("item"));
        this.amount = PlaceholderInt.of((String)mlc.getString("amount", "1"));
        this.override = mlc.getBoolean("override", true);
        this.click_skill = mlc.getString("clickskill");
        if (mlc.getLine().contains("viewonly")) {
            this.view_only = Optional.ofNullable(mlc.getBoolean("viewonly"));
        }
    }

    public boolean cast(SkillMetadata data) {
        this.castAtEntity(data, data.getCaster().getEntity());
        return false;
    }

    public boolean castAtEntity(SkillMetadata data, AbstractEntity abstract_entity) {
        HoldingItem holding = this.holding.clone();
        if (holding != null) {
            ItemStack item_stack;
            if (this.item_name == null || !abstract_entity.isLiving()) {
                return false;
            }
            holding.parseSlot(data, abstract_entity);
            if (this.bag_name != null) {
                holding.setBagName(this.bag_name.get((PlaceholderMeta)data, abstract_entity));
            }
            if ((item_stack = itemmanager.getItemStack(this.item_name.get((PlaceholderMeta)data, abstract_entity))) != null) {
                item_stack.setAmount(this.amount.get((PlaceholderMeta)data, abstract_entity));
                item_stack = NMSUtils.makeReal(item_stack);
                if (this.click_skill != null) {
                    NMSUtils.setMeta(item_stack, "click_skill", this.click_skill);
                }
                if (this.view_only.isPresent()) {
                    NMSUtils.setMetaBoolean(item_stack, str_viewonly, (boolean)this.view_only.get());
                }
                HoldingItem.giveItem((LivingEntity)abstract_entity.getBukkitEntity(), holding, item_stack, this.override);
                return true;
            }
        }
        return false;
    }
}

