/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicmobsext.mechanics;

import com.gmail.berndivader.mythicmobsext.Main;
import com.gmail.berndivader.mythicmobsext.externals.ExternalAnnotation;
import com.gmail.berndivader.mythicmobsext.items.WhereEnum;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

@ExternalAnnotation(name="disarm", author="BerndiVader")
public class DisarmPlayerMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    long dt;
    List<WhereEnum> whats;

    public DisarmPlayerMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        String[] temp;
        this.dt = mlc.getLong(new String[]{"duration", "dur"}, 180L);
        this.whats = new ArrayList<WhereEnum>();
        for (String slot : temp = mlc.getString("what", "HAND").toUpperCase().split(",")) {
            this.whats.add(WhereEnum.getWhere(slot));
        }
    }

    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        final HashMap<WhereEnum, ItemStack> stores = new HashMap<WhereEnum, ItemStack>();
        if (!target.isPlayer()) {
            if (target.isLiving()) {
                final LivingEntity e = (LivingEntity)target.getBukkitEntity();
                block16: for (int i1 = 0; i1 < this.whats.size(); ++i1) {
                    WhereEnum what = this.whats.get(i1);
                    switch (what) {
                        case HAND: {
                            ItemStack equipped_item = DisarmPlayerMechanic.unequipHand(e);
                            if (equipped_item.getType() == Material.AIR) continue block16;
                            stores.put(WhereEnum.HAND, equipped_item);
                            continue block16;
                        }
                        case OFFHAND: {
                            ItemStack equipped_item = DisarmPlayerMechanic.unequipOffHand(e);
                            if (equipped_item.getType() == Material.AIR) continue block16;
                            stores.put(WhereEnum.OFFHAND, equipped_item);
                            continue block16;
                        }
                        case HELMET: {
                            ItemStack equipped_item = DisarmPlayerMechanic.unequipHelmet(e);
                            if (equipped_item.getType() == Material.AIR) continue block16;
                            stores.put(WhereEnum.HELMET, equipped_item);
                            continue block16;
                        }
                        case CHESTPLATE: {
                            ItemStack equipped_item = DisarmPlayerMechanic.unequipChest(e);
                            if (equipped_item.getType() == Material.AIR) continue block16;
                            stores.put(WhereEnum.CHESTPLATE, equipped_item);
                            continue block16;
                        }
                        case LEGGINGS: {
                            ItemStack equipped_item = DisarmPlayerMechanic.unequipLeggings(e);
                            if (equipped_item.getType() == Material.AIR) continue block16;
                            stores.put(WhereEnum.LEGGINGS, equipped_item);
                            continue block16;
                        }
                        case BOOTS: {
                            ItemStack equipped_item = DisarmPlayerMechanic.unequipBoots(e);
                            if (equipped_item.getType() == Material.AIR) continue block16;
                            stores.put(WhereEnum.BOOTS, equipped_item);
                            continue block16;
                        }
                        default: {
                            ItemStack equipped_item = DisarmPlayerMechanic.unequipHand(e);
                            if (equipped_item.getType() != Material.AIR) {
                                stores.put(WhereEnum.HAND, equipped_item);
                            }
                            if ((equipped_item = DisarmPlayerMechanic.unequipOffHand(e)).getType() != Material.AIR) {
                                stores.put(WhereEnum.OFFHAND, equipped_item);
                            }
                            if ((equipped_item = DisarmPlayerMechanic.unequipHelmet(e)).getType() != Material.AIR) {
                                stores.put(WhereEnum.HELMET, equipped_item);
                            }
                            if ((equipped_item = DisarmPlayerMechanic.unequipChest(e)).getType() != Material.AIR) {
                                stores.put(WhereEnum.CHESTPLATE, equipped_item);
                            }
                            if ((equipped_item = DisarmPlayerMechanic.unequipLeggings(e)).getType() != Material.AIR) {
                                stores.put(WhereEnum.LEGGINGS, equipped_item);
                            }
                            if ((equipped_item = DisarmPlayerMechanic.unequipBoots(e)).getType() == Material.AIR) continue block16;
                            stores.put(WhereEnum.BOOTS, equipped_item);
                        }
                    }
                }
                new BukkitRunnable(){

                    public void run() {
                        if (e != null && !e.isDead()) {
                            for (Map.Entry entry : stores.entrySet()) {
                                switch ((WhereEnum)((Object)entry.getKey())) {
                                    case HELMET: {
                                        DisarmPlayerMechanic.equipHelmet(e, (ItemStack)entry.getValue());
                                        break;
                                    }
                                    case CHESTPLATE: {
                                        DisarmPlayerMechanic.equipChest(e, (ItemStack)entry.getValue());
                                        break;
                                    }
                                    case LEGGINGS: {
                                        DisarmPlayerMechanic.equipLeggings(e, (ItemStack)entry.getValue());
                                        break;
                                    }
                                    case BOOTS: {
                                        DisarmPlayerMechanic.equipBoots(e, (ItemStack)entry.getValue());
                                        break;
                                    }
                                    case HAND: {
                                        DisarmPlayerMechanic.equipHand(e, (ItemStack)entry.getValue());
                                        break;
                                    }
                                    case OFFHAND: {
                                        DisarmPlayerMechanic.equipOffHand(e, (ItemStack)entry.getValue());
                                        break;
                                    }
                                }
                            }
                        }
                    }
                }.runTaskLater((Plugin)Main.getPlugin(), this.dt);
            }
        } else {
            Player p = (Player)target.getBukkitEntity();
            int first_empty = p.getInventory().firstEmpty();
            if (first_empty > -1) {
                int size = this.whats.size();
                block17: for (int i1 = 0; i1 < size && (first_empty = p.getInventory().firstEmpty()) != -1; ++i1) {
                    WhereEnum what = this.whats.get(i1);
                    switch (what) {
                        case HAND: {
                            p.getInventory().setItem(first_empty, DisarmPlayerMechanic.unequipHand((LivingEntity)p));
                            continue block17;
                        }
                        case OFFHAND: {
                            p.getInventory().setItem(first_empty, DisarmPlayerMechanic.unequipOffHand((LivingEntity)p));
                            continue block17;
                        }
                        case HELMET: {
                            p.getInventory().setItem(first_empty, DisarmPlayerMechanic.unequipHelmet((LivingEntity)p));
                            continue block17;
                        }
                        case CHESTPLATE: {
                            p.getInventory().setItem(first_empty, DisarmPlayerMechanic.unequipChest((LivingEntity)p));
                            continue block17;
                        }
                        case LEGGINGS: {
                            p.getInventory().setItem(first_empty, DisarmPlayerMechanic.unequipLeggings((LivingEntity)p));
                            continue block17;
                        }
                        case BOOTS: {
                            p.getInventory().setItem(first_empty, DisarmPlayerMechanic.unequipBoots((LivingEntity)p));
                            continue block17;
                        }
                        default: {
                            p.getInventory().setItem(first_empty, DisarmPlayerMechanic.unequipHand((LivingEntity)p));
                            first_empty = p.getInventory().firstEmpty();
                            if (first_empty == -1) continue block17;
                            p.getInventory().setItem(first_empty, DisarmPlayerMechanic.unequipOffHand((LivingEntity)p));
                            first_empty = p.getInventory().firstEmpty();
                            if (first_empty == -1) continue block17;
                            p.getInventory().setItem(first_empty, DisarmPlayerMechanic.unequipHelmet((LivingEntity)p));
                            first_empty = p.getInventory().firstEmpty();
                            if (first_empty == -1) continue block17;
                            p.getInventory().setItem(first_empty, DisarmPlayerMechanic.unequipChest((LivingEntity)p));
                            first_empty = p.getInventory().firstEmpty();
                            if (first_empty == -1) continue block17;
                            p.getInventory().setItem(first_empty, DisarmPlayerMechanic.unequipLeggings((LivingEntity)p));
                            first_empty = p.getInventory().firstEmpty();
                            if (first_empty == -1) continue block17;
                            p.getInventory().setItem(first_empty, DisarmPlayerMechanic.unequipBoots((LivingEntity)p));
                        }
                    }
                }
            }
        }
        return true;
    }

    static ItemStack unequipHand(LivingEntity entity) {
        if (entity.getEquipment().getItemInMainHand() != null) {
            ItemStack item_stack = entity.getEquipment().getItemInMainHand().clone();
            entity.getEquipment().setItemInMainHand(new ItemStack(Material.AIR));
            return item_stack;
        }
        return new ItemStack(Material.AIR);
    }

    static ItemStack unequipOffHand(LivingEntity entity) {
        if (entity.getEquipment().getItemInOffHand() != null) {
            ItemStack item_stack = entity.getEquipment().getItemInOffHand().clone();
            entity.getEquipment().setItemInOffHand(new ItemStack(Material.AIR));
            return item_stack;
        }
        return new ItemStack(Material.AIR);
    }

    static ItemStack unequipHelmet(LivingEntity entity) {
        if (entity.getEquipment().getHelmet() != null) {
            ItemStack item_stack = entity.getEquipment().getHelmet().clone();
            entity.getEquipment().setHelmet(new ItemStack(Material.AIR));
            return item_stack;
        }
        return new ItemStack(Material.AIR);
    }

    static ItemStack unequipChest(LivingEntity entity) {
        if (entity.getEquipment().getChestplate() != null) {
            ItemStack item_stack = entity.getEquipment().getChestplate().clone();
            entity.getEquipment().setChestplate(new ItemStack(Material.AIR));
            return item_stack;
        }
        return new ItemStack(Material.AIR);
    }

    static ItemStack unequipLeggings(LivingEntity entity) {
        if (entity.getEquipment().getLeggings() != null) {
            ItemStack item_stack = entity.getEquipment().getLeggings().clone();
            entity.getEquipment().setLeggings(new ItemStack(Material.AIR));
            return item_stack;
        }
        return new ItemStack(Material.AIR);
    }

    static ItemStack unequipBoots(LivingEntity entity) {
        if (entity.getEquipment().getBoots() != null) {
            ItemStack item_stack = entity.getEquipment().getBoots().clone();
            entity.getEquipment().setBoots(new ItemStack(Material.AIR));
            return item_stack;
        }
        return new ItemStack(Material.AIR);
    }

    static void equipHelmet(LivingEntity entity, ItemStack item) {
        entity.getEquipment().setHelmet(item);
    }

    static void equipChest(LivingEntity entity, ItemStack item) {
        entity.getEquipment().setChestplate(item);
    }

    static void equipLeggings(LivingEntity entity, ItemStack item) {
        entity.getEquipment().setLeggings(item);
    }

    static void equipBoots(LivingEntity entity, ItemStack item) {
        entity.getEquipment().setBoots(item);
    }

    static void equipHand(LivingEntity entity, ItemStack item) {
        entity.getEquipment().setItemInMainHand(item);
    }

    static void equipOffHand(LivingEntity entity, ItemStack item) {
        entity.getEquipment().setItemInOffHand(item);
    }
}

