/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicmobsext.mechanics;

import com.gmail.berndivader.mythicmobsext.Main;
import com.gmail.berndivader.mythicmobsext.externals.ExternalAnnotation;
import com.gmail.berndivader.mythicmobsext.items.Enchant;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.AbstractSkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;

@ExternalAnnotation(name="enchant,enchantweaponry", author="BerndiVader")
public class EnchantWeaponryMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    boolean set;
    byte what;
    ACTION action;
    List<Enchant> enchants;

    public EnchantWeaponryMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        int i1;
        this.threadSafetyLevel = AbstractSkill.ThreadSafetyLevel.SYNC_ONLY;
        this.action = ACTION.SET;
        try {
            this.action = ACTION.valueOf(mlc.getString("action", "SET").toUpperCase());
        }
        catch (Exception ex) {
            Main.logger.warning("Use default because of wrong action in enchant skill " + this.line);
        }
        String[] arr1 = mlc.getString("what", "").toUpperCase().split(",");
        int length = arr1.length;
        this.what = 0;
        WHAT_ENUM what_enum = null;
        for (i1 = 0; i1 < length; ++i1) {
            try {
                what_enum = WHAT_ENUM.valueOf(arr1[i1]);
            }
            catch (Exception ex) {
                Main.logger.warning("Ignore what position " + arr1[i1] + " in " + this.line);
                continue;
            }
            this.what = (byte)(this.what | what_enum.get());
        }
        this.enchants = new ArrayList<Enchant>();
        arr1 = mlc.getString("enchants", "").toUpperCase().split(",");
        length = arr1.length;
        for (i1 = 0; i1 < length; ++i1) {
            Enchantment ench;
            String[] parse = arr1[i1].split(":");
            String name = parse[0];
            String level = "1";
            if (parse.length > 0) {
                try {
                    level = parse[1];
                }
                catch (Exception ex) {
                    Main.logger.warning("Error parsing level in " + this.line);
                    level = "1";
                }
            }
            if ((ench = Enchantment.getByName((String)name)) != null) {
                this.enchants.add(new Enchant(ench, level));
                continue;
            }
            Main.logger.warning("Ignore enchantment " + name + " in " + this.line);
        }
    }

    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (!target.isLiving()) {
            return false;
        }
        LivingEntity entity = (LivingEntity)target.getBukkitEntity();
        block8: for (int i1 = 0; i1 < 6; ++i1) {
            if ((this.what >> i1 & 1) != 1) continue;
            switch (i1) {
                case 0: {
                    ItemStack stack = entity.getEquipment().getItemInMainHand();
                    if (!EnchantWeaponryMechanic.isValidMaterial(stack)) continue block8;
                    stack = new ItemStack(stack);
                    stack = EnchantWeaponryMechanic.enchantAction(stack, this.action, this.enchants);
                    entity.getEquipment().setItemInMainHand(stack.clone());
                    continue block8;
                }
                case 1: {
                    ItemStack stack = entity.getEquipment().getItemInOffHand();
                    if (!EnchantWeaponryMechanic.isValidMaterial(stack)) continue block8;
                    stack = new ItemStack(stack);
                    stack = EnchantWeaponryMechanic.enchantAction(stack, this.action, this.enchants);
                    entity.getEquipment().setItemInOffHand(stack.clone());
                    continue block8;
                }
                case 2: {
                    ItemStack stack = entity.getEquipment().getHelmet();
                    if (!EnchantWeaponryMechanic.isValidMaterial(stack)) continue block8;
                    stack = new ItemStack(stack);
                    stack = EnchantWeaponryMechanic.enchantAction(stack, this.action, this.enchants);
                    entity.getEquipment().setHelmet(stack.clone());
                    continue block8;
                }
                case 3: {
                    ItemStack stack = entity.getEquipment().getChestplate();
                    if (!EnchantWeaponryMechanic.isValidMaterial(stack)) continue block8;
                    stack = new ItemStack(stack);
                    stack = EnchantWeaponryMechanic.enchantAction(stack, this.action, this.enchants);
                    entity.getEquipment().setChestplate(stack.clone());
                    continue block8;
                }
                case 4: {
                    ItemStack stack = entity.getEquipment().getLeggings();
                    if (!EnchantWeaponryMechanic.isValidMaterial(stack)) continue block8;
                    stack = new ItemStack(stack);
                    stack = EnchantWeaponryMechanic.enchantAction(stack, this.action, this.enchants);
                    entity.getEquipment().setLeggings(stack.clone());
                    continue block8;
                }
                case 5: {
                    ItemStack stack = entity.getEquipment().getBoots();
                    if (!EnchantWeaponryMechanic.isValidMaterial(stack)) continue block8;
                    stack = new ItemStack(stack);
                    stack = EnchantWeaponryMechanic.enchantAction(stack, this.action, this.enchants);
                    entity.getEquipment().setBoots(stack.clone());
                }
            }
        }
        return true;
    }

    static boolean isValidMaterial(ItemStack stack) {
        return stack != null && stack.getType() != Material.AIR;
    }

    static ItemStack enchantAction(ItemStack stack, ACTION action, List<Enchant> enchants) {
        int length = enchants.size();
        switch (action) {
            case SET: {
                for (int i1 = 0; i1 < length; ++i1) {
                    Enchantment enchant = enchants.get((int)i1).enchantment;
                    if (stack.containsEnchantment(enchant)) {
                        stack.removeEnchantment(enchant);
                        continue;
                    }
                    stack.addUnsafeEnchantment(enchant, enchants.get((int)i1).level.rollInteger());
                }
                break;
            }
            case ADD: {
                for (int i1 = 0; i1 < length; ++i1) {
                    Enchantment enchant = enchants.get((int)i1).enchantment;
                    stack.addUnsafeEnchantment(enchant, enchants.get((int)i1).level.rollInteger());
                }
                break;
            }
            case DEL: {
                for (int i1 = 0; i1 < length; ++i1) {
                    Enchantment enchant = enchants.get((int)i1).enchantment;
                    if (!stack.containsEnchantment(enchant)) continue;
                    stack.removeEnchantment(enchant);
                }
                break;
            }
        }
        return stack;
    }

    static enum ACTION {
        SET,
        ADD,
        DEL;

    }

    static enum WHAT_ENUM {
        MAINHAND(1),
        OFFHAND(2),
        HEAD(4),
        CHEST(8),
        LEGS(16),
        SHOES(32);

        private byte what;

        private WHAT_ENUM(byte value) {
            this.what = value;
        }

        public byte get() {
            return this.what;
        }
    }
}

