/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicmobsext.mechanics;

import com.gmail.berndivader.mythicmobsext.externals.ExternalAnnotation;
import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractItemStack;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.items.MythicItem;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.placeholders.PlaceholderMeta;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderInt;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

@ExternalAnnotation(name="transmuteitem", author="Seyarada")
public class TransmuteItem
extends SkillMechanic
implements ITargetedEntitySkill {
    PlaceholderInt amount;
    ItemStack baseItem;
    ItemStack resultItem;
    Material resultMaterial;
    String resultMLC;

    public TransmuteItem(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.amount = PlaceholderInt.of((String)mlc.getString(new String[]{"amount", "a"}, "-1", new String[0]));
        String baseMLC = mlc.getString(new String[]{"item", "i"}, "STONE", new String[0]);
        try {
            Material baseMaterial = Material.valueOf((String)baseMLC);
            this.baseItem = new ItemStack(baseMaterial);
        }
        catch (Exception e) {
            ItemStack item;
            Optional t = MythicMobs.inst().getItemManager().getItem(baseMLC);
            this.baseItem = item = BukkitAdapter.adapt((AbstractItemStack)((MythicItem)t.get()).generateItemStack(1));
        }
        this.resultMLC = mlc.getString(new String[]{"result", "r"}, "DIRT", new String[0]);
    }

    public ItemStack generateItemStack(int quantity) {
        try {
            Material resultMaterial = Material.valueOf((String)this.resultMLC);
            this.resultItem = new ItemStack(resultMaterial, quantity);
        }
        catch (Exception e) {
            ItemStack mythicItem;
            Optional t = MythicMobs.inst().getItemManager().getItem(this.resultMLC);
            this.resultItem = mythicItem = BukkitAdapter.adapt((AbstractItemStack)((MythicItem)t.get()).generateItemStack(quantity));
        }
        return this.resultItem;
    }

    public boolean castAtEntity(SkillMetadata data, AbstractEntity p) {
        int altAmount = this.amount.get((PlaceholderMeta)data, p);
        if (p.isPlayer()) {
            Player player = (Player)p.getBukkitEntity();
            ItemStack[] baseContent = player.getInventory().getContents();
            for (int i = 0; i < player.getInventory().getSize(); ++i) {
                if (baseContent[i] == null || !baseContent[i].isSimilar(this.baseItem)) continue;
                int quantity = baseContent[i].getAmount();
                if (altAmount < 0) {
                    this.resultItem = this.generateItemStack(quantity);
                    player.getInventory().setItem(i, this.resultItem);
                    continue;
                }
                if (quantity > altAmount && altAmount != 0) {
                    baseContent[i].setAmount(quantity - altAmount);
                    player.getInventory().addItem(new ItemStack[]{this.generateItemStack(altAmount)});
                    altAmount = 0;
                    continue;
                }
                if (altAmount == 0) continue;
                this.resultItem = this.generateItemStack(quantity);
                player.getInventory().setItem(i, this.resultItem);
                altAmount -= quantity;
            }
        }
        return true;
    }
}

