/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicmobsext.mechanics;

import com.gmail.berndivader.mythicmobsext.Main;
import com.gmail.berndivader.mythicmobsext.externals.ExternalAnnotation;
import com.gmail.berndivader.mythicmobsext.utils.math.MathUtils;
import com.gmail.berndivader.mythicmobsext.volatilecode.Volatile;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

@ExternalAnnotation(name="setrotation", author="BerndiVader")
public class SetRotationMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    public static String str = "mmRotate";
    private float yawOff;
    private float pitchOff;
    private long d;

    public SetRotationMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.yawOff = mlc.getFloat(new String[]{"yawoffset", "yaw", "yo", "y"}, 5.0f);
        this.pitchOff = mlc.getFloat(new String[]{"pitchoffset", "pitch", "po", "p"}, 0.0f);
        this.d = mlc.getLong(new String[]{"duration", "dur"}, 1L);
    }

    public boolean castAtEntity(SkillMetadata data, final AbstractEntity target) {
        if (target.isPlayer()) {
            return false;
        }
        if (target.getBukkitEntity().hasMetadata(str)) {
            target.getBukkitEntity().removeMetadata(str, (Plugin)Main.getPlugin());
        }
        final float yo = this.yawOff;
        final float po = this.pitchOff;
        final long d = this.d;
        target.getBukkitEntity().setMetadata(str, (MetadataValue)new FixedMetadataValue((Plugin)Main.getPlugin(), (Object)true));
        new BukkitRunnable(){
            float yaw;
            float pitch;
            long c;
            {
                this.yaw = target.getBukkitEntity().getLocation().getYaw();
                this.pitch = target.getBukkitEntity().getLocation().getPitch();
                this.c = 0L;
            }

            public void run() {
                if (this.c > d || target.isDead() || !target.getBukkitEntity().hasMetadata(str)) {
                    if (!target.isDead()) {
                        target.getBukkitEntity().removeMetadata(str, (Plugin)Main.getPlugin());
                    }
                    this.cancel();
                } else {
                    this.yaw = MathUtils.normalise(this.yaw + yo, 0.0f, 360.0f);
                    this.pitch = MathUtils.normalise(this.pitch + po, 0.0f, 360.0f);
                    Volatile.handler.rotateEntityPacket(target.getBukkitEntity(), this.yaw, this.pitch);
                }
                ++this.c;
            }
        }.runTaskTimerAsynchronously((Plugin)Main.getPlugin(), 1L, 1L);
        return true;
    }
}

