/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicmobsext.volatilecode.v1_16_R1.pathfindergoals;

import com.gmail.berndivader.mythicmobsext.Main;
import java.util.HashSet;
import net.minecraft.server.v1_16_R1.BlockPosition;
import net.minecraft.server.v1_16_R1.Entity;
import net.minecraft.server.v1_16_R1.EntityInsentient;
import net.minecraft.server.v1_16_R1.EntityLiving;
import net.minecraft.server.v1_16_R1.IBlockData;
import net.minecraft.server.v1_16_R1.PathfinderGoal;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_16_R1.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class PathfinderGoalBreakBlocks
extends PathfinderGoal {
    protected EntityInsentient entity;
    protected boolean isBreaking = false;
    protected int chance;
    protected HashSet<Material> materials;
    Block[] blocks = new Block[2];

    public PathfinderGoalBreakBlocks(EntityInsentient entity, String mL, int chance) {
        this.entity = entity;
        this.materials = new HashSet();
        int n = chance > 100 ? 100 : (this.chance = chance < 0 ? 0 : chance);
        if (mL != null) {
            String[] parse = mL.toUpperCase().split(",");
            for (int a2 = 0; a2 < parse.length; ++a2) {
                try {
                    this.materials.add(Material.valueOf((String)parse[a2]));
                    continue;
                }
                catch (Exception ex) {
                    Main.logger.warning("Material " + parse[a2] + " is not valid for PathfinderGoalBreakBlocks.");
                }
            }
        }
    }

    public boolean a() {
        return this.entity.isAlive();
    }

    public boolean b() {
        return this.entity.getGoalTarget() != null && this.entity.getGoalTarget().isAlive();
    }

    public void e() {
        if (!this.canContinue()) {
            return;
        }
        EntityLiving target = this.entity.getGoalTarget();
        this.blocks[1] = this.getBreakableTargetBlock(target);
        this.blocks[0] = this.blocks[1].getRelative(BlockFace.UP);
        for (int a2 = 0; a2 < 2; ++a2) {
            if (!this.materials.isEmpty() && !this.materials.contains(this.blocks[a2].getType())) continue;
            this.attemptBreakBlock(this.blocks[a2]);
        }
    }

    private boolean canContinue() {
        if (Main.random.nextInt(100) <= this.chance) {
            EntityLiving target = this.entity.getGoalTarget();
            return target != null && target.isAlive() && !this.isBreaking && !this.isReachable(target);
        }
        return false;
    }

    private Block getBreakableTargetBlock(EntityLiving target) {
        Vector direction = ((LivingEntity)this.entity.getBukkitEntity()).getLocation().getDirection();
        double dx = direction.getX();
        double dz = direction.getY();
        int bdx = 0;
        int bdz = 0;
        if (Math.abs(dx) > Math.abs(dz)) {
            bdx = dx > 0.0 ? 1 : -1;
        } else {
            bdz = dx > 0.0 ? 1 : -1;
        }
        return this.entity.world.getWorld().getBlockAt((int)Math.floor(this.entity.locX() + (double)bdx), (int)Math.floor(this.entity.locY()), (int)Math.floor(this.entity.locZ() + (double)bdz));
    }

    private void attemptBreakBlock(final Block block) {
        Material type = block.getType();
        if (!this.isBreaking && type != Material.AIR && type.isSolid() && Main.random.nextInt(100) <= this.chance) {
            this.isBreaking = true;
            PotionEffect effect = new PotionEffect(PotionEffectType.SLOW, 20, 4, false, false);
            ((LivingEntity)this.entity.getBukkitEntity()).addPotionEffect(effect);
            new BukkitRunnable(){

                public void run() {
                    BlockPosition position = new BlockPosition(block.getX(), block.getY(), block.getZ());
                    if (!CraftEventFactory.callEntityChangeBlockEvent((Entity)PathfinderGoalBreakBlocks.this.entity, (BlockPosition)position, (IBlockData)PathfinderGoalBreakBlocks.this.entity.world.getType(position).getBlock().getBlockData()).isCancelled()) {
                        PathfinderGoalBreakBlocks.this.entity.world.triggerEffect(2001, position, net.minecraft.server.v1_16_R1.Block.getCombinedId((IBlockData)PathfinderGoalBreakBlocks.this.entity.world.getType(position)));
                        block.breakNaturally();
                        PathfinderGoalBreakBlocks.this.isBreaking = false;
                    }
                }
            }.runTaskLater((Plugin)Main.getPlugin(), 20L);
        }
    }

    private boolean isReachable(EntityLiving target) {
        if (target == null) {
            return true;
        }
        return this.entity.hasLineOfSight((Entity)target);
    }
}

