/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicmobsext.backbags.mechanics;

import com.gmail.berndivader.mythicmobsext.Main;
import com.gmail.berndivader.mythicmobsext.backbags.BackBagHelper;
import com.gmail.berndivader.mythicmobsext.backbags.BackBagViewer;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.AbstractSkill;
import io.lumine.xikage.mythicmobs.skills.INoTargetSkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.placeholders.PlaceholderMeta;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderString;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class OpenBackBag
extends SkillMechanic
implements INoTargetSkill,
ITargetedEntitySkill {
    int size;
    ItemStack[] default_items;
    boolean view_only;
    boolean temporary;
    PlaceholderString bag_name;
    List<Integer> excluded_slots;

    public OpenBackBag(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.threadSafetyLevel = AbstractSkill.ThreadSafetyLevel.SYNC_ONLY;
        this.size = mlc.getInteger("size", 9);
        this.view_only = mlc.getBoolean("viewonly", true);
        this.default_items = BackBagHelper.createDefaultItemStack(mlc.getString("items", null));
        this.bag_name = mlc.getPlaceholderString(new String[]{"name", "title"}, "BackBag", new String[0]);
        this.temporary = mlc.getBoolean("temporary", false);
        String[] temp = mlc.getString("excludedslots", "").split(",");
        this.excluded_slots = new ArrayList<Integer>();
        for (int i1 = 0; i1 < temp.length; ++i1) {
            try {
                if (temp[i1].isEmpty()) continue;
                int slot = Integer.parseInt(temp[i1]);
                this.excluded_slots.add(slot);
                continue;
            }
            catch (Exception ex) {
                Main.logger.warning("Ignoring " + temp[i1] + " in skill " + skill + " its not a valid slot number.");
            }
        }
    }

    public boolean cast(SkillMetadata data) {
        if (data.getCaster().getEntity().isPlayer()) {
            Player player = (Player)data.getCaster().getEntity().getBukkitEntity();
            BackBagViewer bag = new BackBagViewer((Entity)player, this.size, this.default_items, this.bag_name.get((PlaceholderMeta)data), this.temporary);
            bag.viewBackBag(player, this.view_only, this.excluded_slots);
            return true;
        }
        return false;
    }

    public boolean castAtEntity(SkillMetadata data, AbstractEntity abstract_entity) {
        if (abstract_entity.isPlayer()) {
            Entity holder = data.getCaster().getEntity().getBukkitEntity();
            Player viewer = (Player)abstract_entity.getBukkitEntity();
            BackBagViewer bag = new BackBagViewer(holder, this.size, this.default_items, this.bag_name.get((PlaceholderMeta)data, abstract_entity), this.temporary);
            bag.viewBackBag(viewer, this.view_only, this.excluded_slots);
            return true;
        }
        return false;
    }
}

