/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicmobsext.conditions;

import com.gmail.berndivader.mythicmobsext.conditions.AbstractCustomCondition;
import com.gmail.berndivader.mythicmobsext.externals.ExternalAnnotation;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.conditions.IEntityCondition;
import java.util.HashSet;
import java.util.Iterator;
import org.bukkit.Bukkit;
import org.bukkit.advancement.Advancement;
import org.bukkit.entity.Player;

@ExternalAnnotation(name="advancement,hasadvancement,advancements,hasadvancements", author="BerndiVader")
public class HasAdvancementsCondition
extends AbstractCustomCondition
implements IEntityCondition {
    HashSet<Advancement> advs = new HashSet();

    public HasAdvancementsCondition(String line, MythicLineConfig mlc) {
        super(line, mlc);
        String[] arr1 = mlc.getString(new String[]{"advancement", "adv", "advancements"}, "", new String[0]).toLowerCase().split(",");
        Iterator iter = Bukkit.getServer().advancementIterator();
        while (iter.hasNext()) {
            Advancement adv = (Advancement)iter.next();
            for (int i1 = 0; i1 < arr1.length; ++i1) {
                if (!adv.getKey().getKey().toLowerCase().equals(arr1[i1])) continue;
                this.advs.add(adv);
            }
        }
    }

    public boolean check(AbstractEntity entity) {
        if (entity.isPlayer()) {
            Player p = (Player)entity.getBukkitEntity();
            for (Advancement adv : this.advs) {
                if (!p.getAdvancementProgress(adv).isDone()) continue;
                return true;
            }
        }
        return false;
    }
}

