/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicmobsext.guardianbeam;

import com.gmail.berndivader.mythicmobsext.guardianbeam.PacketFactory;
import com.gmail.berndivader.mythicmobsext.guardianbeam.WrappedBeamPacket;
import com.google.common.base.Preconditions;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class LocationTargetBeam {
    private final WrappedBeamPacket packetSquidSpawn;
    private final WrappedBeamPacket packetSquidMove;
    private final WrappedBeamPacket packetGuardianSpawn;
    private final WrappedBeamPacket packetGuardianMove;
    private final WrappedBeamPacket packetRemoveEntities;

    public LocationTargetBeam(Location startingPosition, Location endingPosition) {
        Preconditions.checkNotNull((Object)startingPosition, (Object)"startingPosition cannot be null");
        Preconditions.checkNotNull((Object)endingPosition, (Object)"endingPosition cannot be null");
        Preconditions.checkState((boolean)startingPosition.getWorld().equals(endingPosition.getWorld()), (Object)"startingPosition and endingPosition must be in the same world");
        this.packetSquidSpawn = PacketFactory.createPacketSquidSpawn(endingPosition);
        this.packetSquidMove = PacketFactory.createPacketEntityMove(this.packetSquidSpawn);
        this.packetGuardianSpawn = PacketFactory.createPacketGuardianSpawn(startingPosition, this.packetSquidSpawn);
        this.packetGuardianMove = PacketFactory.createPacketEntityMove(this.packetGuardianSpawn);
        this.packetRemoveEntities = PacketFactory.createPacketRemoveEntities(this.packetSquidSpawn, this.packetGuardianSpawn);
    }

    public void start(Player player) {
        this.packetSquidSpawn.send(player);
        this.packetGuardianSpawn.send(player);
    }

    public void setStartingPosition(Player player, Location location) {
        Location l = new Location(location.getWorld(), 0.0, 0.0, 0.0);
        PacketFactory.modifyPacketEntitySpawn(this.packetSquidSpawn, l).send(player);
        PacketFactory.modifyPacketEntityMove(this.packetGuardianMove, location).send(player);
    }

    public void setEndingPosition(Player player, Location location) {
        PacketFactory.modifyPacketEntitySpawn(this.packetSquidSpawn, location).send(player);
    }

    public void cleanup(Player player) {
        this.packetRemoveEntities.send(player);
    }
}

