/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicmobsext.conditions;

import com.gmail.berndivader.mythicmobsext.conditions.AbstractCustomCondition;
import com.gmail.berndivader.mythicmobsext.externals.ExternalAnnotation;
import com.gmail.berndivader.mythicmobsext.utils.math.MathUtils;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.conditions.IEntityComparisonCondition;
import org.bukkit.Location;
import org.bukkit.util.Vector;

@ExternalAnnotation(name="infront", author="BerndiVader")
public class InFrontCondition
extends AbstractCustomCondition
implements IEntityComparisonCondition {
    protected double viewAngle;

    public InFrontCondition(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.viewAngle = MathUtils.round(mlc.getDouble(new String[]{"view", "angle", "v"}, 45.0), 3);
    }

    public boolean check(AbstractEntity source, AbstractEntity target) {
        Vector r;
        Location s = source.getBukkitEntity().getLocation();
        Location t = target.getBukkitEntity().getLocation();
        double dT = Math.cos(this.viewAngle);
        Vector f = s.getDirection();
        return Math.toDegrees(Math.asin(f.dot(r = t.subtract(s).toVector().normalize()))) >= dT;
    }
}

