/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicmobsext.bossbars.mechanics;

import com.gmail.berndivader.mythicmobsext.Main;
import com.gmail.berndivader.mythicmobsext.bossbars.BossBars;
import com.gmail.berndivader.mythicmobsext.utils.math.MathUtils;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.placeholders.PlaceholderMeta;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderString;
import org.bukkit.boss.BossBar;

public class ProgressBossBar
extends SkillMechanic
implements ITargetedEntitySkill {
    PlaceholderString title;
    PlaceholderString expr;
    boolean set;

    public ProgressBossBar(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.title = mlc.getPlaceholderString("title", "Bar");
        this.set = mlc.getBoolean("set", false);
        this.expr = mlc.getPlaceholderString("value", "0.05d");
    }

    public boolean castAtEntity(SkillMetadata data, AbstractEntity abstract_entity) {
        if (abstract_entity.isPlayer()) {
            BossBar bar;
            double value = 0.0;
            String parsed_expr = this.expr.get((PlaceholderMeta)data, abstract_entity);
            try {
                value = Double.parseDouble(parsed_expr);
            }
            catch (Exception e) {
                Main.logger.info(parsed_expr + " is not valid for double in " + this.line);
                value = 0.0;
            }
            int delta = value > 0.0 ? 1 : -1;
            value = Math.abs(value);
            if (BossBars.contains(abstract_entity.getUniqueId()) && (bar = BossBars.getBar(abstract_entity.getUniqueId(), this.title.get((PlaceholderMeta)data, abstract_entity))) != null) {
                bar.setProgress(MathUtils.clamp(this.set ? value : bar.getProgress() + value * (double)delta, 0.0, 1.0));
            }
        }
        return false;
    }
}

