/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicskript.functions.mechanics;

import ch.njol.skript.lang.function.Function;
import ch.njol.skript.lang.function.Functions;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.INoTargetSkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedLocationSkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;

public class SkriptfunctionMechanic
extends SkillMechanic
implements INoTargetSkill,
ITargetedEntitySkill,
ITargetedLocationSkill {
    Function<?> function;
    Object[][] parameters;
    int dataPos;
    int locationPos;
    int entityPos;
    String name;

    public SkriptfunctionMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.name = mlc.getString("name", "");
        this.function = Functions.getGlobalFunction((String)this.name);
        if (this.function != null) {
            this.parameters = new Object[this.function.getParameters().length][];
            this.entityPos = -1;
            this.locationPos = -1;
            this.dataPos = -1;
            block10: for (int i = 0; i < this.function.getParameters().length; ++i) {
                String type;
                switch (type = this.function.getParameter(i).getType().getCodeName()) {
                    case "skilldata": {
                        this.dataPos = i;
                        continue block10;
                    }
                    case "location": {
                        this.locationPos = i;
                        continue block10;
                    }
                    case "entity": {
                        this.entityPos = i;
                    }
                }
            }
        } else {
            Bukkit.getLogger().warning("Cant find function " + this.name);
        }
    }

    public boolean cast(SkillMetadata meta) {
        if (this.dataPos > -1) {
            this.parameters[this.dataPos] = new SkillMetadata[]{meta};
        }
        if (this.locationPos > -1) {
            this.parameters[this.locationPos] = new Location[0];
        }
        if (this.entityPos > -1) {
            this.parameters[this.entityPos] = new Entity[0];
        }
        this.function.execute(this.parameters);
        return true;
    }

    public boolean castAtLocation(SkillMetadata meta, AbstractLocation aLocation) {
        if (this.dataPos > -1) {
            this.parameters[this.dataPos] = new SkillMetadata[]{meta};
        }
        if (this.locationPos > -1) {
            this.parameters[this.locationPos] = new Location[]{BukkitAdapter.adapt((AbstractLocation)aLocation)};
        }
        if (this.entityPos > -1) {
            this.parameters[this.entityPos] = new Entity[0];
        }
        this.function.execute(this.parameters);
        return true;
    }

    public boolean castAtEntity(SkillMetadata meta, AbstractEntity aEntity) {
        if (this.dataPos > -1) {
            this.parameters[this.dataPos] = new SkillMetadata[]{meta};
        }
        if (this.locationPos > -1) {
            this.parameters[this.locationPos] = new Location[0];
        }
        if (this.entityPos > -1) {
            this.parameters[this.entityPos] = new Entity[]{aEntity.getBukkitEntity()};
        }
        this.function.execute(this.parameters);
        return true;
    }
}

