/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicskript.expressions;

import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.mobs.MythicMob;
import javax.annotation.Nullable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.plugin.Plugin;

public class ConvertToMythicMob
extends SimpleExpression<ActiveMob> {
    private Expression<String> skMobtype;
    private Expression<Entity> skEntity;
    private Expression<Number> skLevel;

    public boolean isSingle() {
        return true;
    }

    public Class<? extends ActiveMob> getReturnType() {
        return ActiveMob.class;
    }

    public boolean init(Expression<?>[] expr, int pattern, Kleenean var3, SkriptParser.ParseResult var4) {
        this.skEntity = expr[0];
        this.skMobtype = expr[1];
        this.skLevel = expr[2];
        return true;
    }

    public String toString(@Nullable Event e, boolean bool) {
        return null;
    }

    @Nullable
    protected ActiveMob[] get(Event e) {
        String type = (String)this.skMobtype.getSingle(e);
        ActiveMob am = null;
        Entity entity = (Entity)this.skEntity.getSingle(e);
        if (!(entity instanceof LivingEntity)) {
            return null;
        }
        LivingEntity le = (LivingEntity)entity;
        boolean isplayer = le instanceof Player;
        int level = ((Number)this.skLevel.getSingle(e)).intValue();
        MythicMob mm = MythicMobs.inst().getMobManager().getMythicMob(type);
        if (mm == null) {
            return null;
        }
        if (isplayer && !mm.isPersistent()) {
            return null;
        }
        am = new ActiveMob(le.getUniqueId(), BukkitAdapter.adapt((Entity)le), mm, (double)level);
        if (am != null) {
            ConvertToMythicMob.addActiveMobToFaction(mm, am);
            ConvertToMythicMob.registerActiveMob(am);
        }
        return new ActiveMob[]{am};
    }

    public static void addActiveMobToFaction(MythicMob mm, ActiveMob am) {
        if (mm.hasFaction()) {
            am.setFaction(mm.getFaction());
            am.getEntity().setMetadata("Faction", (Object)new FixedMetadataValue((Plugin)MythicMobs.inst(), (Object)mm.getFaction()));
        }
    }

    public static void registerActiveMob(ActiveMob am) {
        MythicMobs.inst().getMobManager().registerActiveMob(am);
    }
}

