/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.remote;

import com.sedmelluq.discord.lavaplayer.remote.RemoteAudioTrackExecutor;
import com.sedmelluq.discord.lavaplayer.remote.RemoteNodeProcessor;
import com.sedmelluq.discord.lavaplayer.remote.message.NodeStatisticsMessage;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackState;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbandonedTrackManager {
    private static final Logger log = LoggerFactory.getLogger(AbandonedTrackManager.class);
    private static final long EXPIRE_THRESHOLD = TimeUnit.SECONDS.toMillis(10L);
    private static final long CRITICAL_PENALTY = 750L;
    private final BlockingQueue<AbandonedExecutor> abandonedExecutors = new ArrayBlockingQueue<AbandonedExecutor>(2000);

    public void add(RemoteAudioTrackExecutor executor) {
        if (this.abandonedExecutors.offer(new AbandonedExecutor(System.currentTimeMillis(), executor))) {
            log.debug("{} has been put up for adoption.", (Object)executor);
        } else {
            log.debug("{} has been discarded, adoption queue is full.", (Object)executor);
            executor.dispatchException(new FriendlyException("Cannot find a node to play the track on.", FriendlyException.Severity.COMMON, null));
            executor.stop();
        }
    }

    public void distribute(List<RemoteNodeProcessor> nodes) {
        AbandonedExecutor executor;
        if (this.abandonedExecutors.isEmpty()) {
            return;
        }
        List<Adopter> adopters = this.findAdopters(nodes);
        long currentTime = System.currentTimeMillis();
        int maximum = this.getMaximumAdoptions(adopters);
        int assigned = 0;
        while (assigned < maximum && (executor = (AbandonedExecutor)this.abandonedExecutors.poll()) != null) {
            if (!this.checkValidity(executor, currentTime)) continue;
            Adopter adopter = this.selectNextAdopter(adopters);
            if (adopter != null) {
                log.debug("Node {} is adopting {}.", (Object)adopter.node.getAddress(), (Object)executor.executor);
                adopter.node.startPlaying(executor.executor);
                ++assigned;
                continue;
            }
            log.debug("No node available for adopting {}", (Object)executor.executor);
        }
    }

    public void shutdown() {
        AbandonedExecutor executor;
        while ((executor = (AbandonedExecutor)this.abandonedExecutors.poll()) != null) {
            executor.executor.dispatchException(new FriendlyException("Node system was shut down.", FriendlyException.Severity.COMMON, null));
            executor.executor.stop();
        }
    }

    public void drainExpired() {
        AbandonedExecutor executor;
        long currentTime = System.currentTimeMillis();
        while ((executor = (AbandonedExecutor)this.abandonedExecutors.peek()) != null) {
            if (this.checkValidity(executor, currentTime) || !this.abandonedExecutors.remove(executor)) continue;
            log.debug("Abandoned executor {} removed from queue.", (Object)executor.executor);
        }
    }

    private boolean checkValidity(AbandonedExecutor executor, long currentTime) {
        long expirationTime = currentTime - EXPIRE_THRESHOLD;
        if (executor.executor.getState() == AudioTrackState.FINISHED) {
            log.debug("{} has been cleared from adoption queue because it was stopped.", (Object)executor.executor);
            return false;
        }
        if (executor.orphanedTime < expirationTime) {
            log.debug("{} has been cleared from adoption queue because it expired.", (Object)executor.executor);
            executor.executor.dispatchException(new FriendlyException("Could not find next node to play on.", FriendlyException.Severity.COMMON, null));
            executor.executor.stop();
            return false;
        }
        return true;
    }

    private List<Adopter> findAdopters(List<RemoteNodeProcessor> nodes) {
        ArrayList<Adopter> adopters = new ArrayList<Adopter>();
        for (RemoteNodeProcessor node : nodes) {
            int penalty = node.getBalancerPenalty();
            NodeStatisticsMessage statistics = node.getLastStatistics();
            if ((long)penalty >= 750L || statistics == null) continue;
            int maximumAdoptions = Math.max(5, statistics.playingTrackCount / 15);
            adopters.add(new Adopter(node, maximumAdoptions));
        }
        return adopters;
    }

    private Adopter selectNextAdopter(List<Adopter> adopters) {
        Adopter selected = null;
        for (Adopter adopter : adopters) {
            if ((long)adopter.adoptions >= adopter.maximumAdoptions || selected != null && !(adopter.fillRate() > selected.fillRate())) continue;
            selected = adopter;
        }
        if (selected != null) {
            selected.adoptions++;
        }
        return selected;
    }

    private int getMaximumAdoptions(List<Adopter> adopters) {
        int total = 0;
        for (Adopter adopter : adopters) {
            total = (int)((long)total + adopter.maximumAdoptions);
        }
        return total;
    }

    private static class Adopter {
        private final RemoteNodeProcessor node;
        private final long maximumAdoptions;
        private int adoptions;

        private Adopter(RemoteNodeProcessor node, long maximumAdoptions) {
            this.node = node;
            this.maximumAdoptions = maximumAdoptions;
            this.adoptions = 0;
        }

        private float fillRate() {
            return (float)this.adoptions / (float)this.maximumAdoptions;
        }
    }

    private static class AbandonedExecutor {
        private final long orphanedTime;
        private final RemoteAudioTrackExecutor executor;

        private AbandonedExecutor(long orphanedTime, RemoteAudioTrackExecutor executor) {
            this.orphanedTime = orphanedTime;
            this.executor = executor;
        }
    }
}

