/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.DiscordObject;
import discord4j.core.object.entity.User;
import discord4j.discordjson.json.MessageInteractionData;
import discord4j.rest.util.ApplicationCommandOptionType;
import java.util.Objects;

public class MessageInteraction
implements DiscordObject {
    private final GatewayDiscordClient gateway;
    private final MessageInteractionData data;

    public MessageInteraction(GatewayDiscordClient gateway, MessageInteractionData data) {
        this.gateway = Objects.requireNonNull(gateway);
        this.data = Objects.requireNonNull(data);
    }

    public Snowflake getId() {
        return Snowflake.of(this.data.id());
    }

    public ApplicationCommandOptionType getType() {
        return ApplicationCommandOptionType.of(this.data.type());
    }

    public String getName() {
        return this.data.name();
    }

    public User getUser() {
        return new User(this.gateway, this.data.user());
    }

    @Override
    public final GatewayDiscordClient getClient() {
        return this.gateway;
    }
}

