/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.entity;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.entity.ApplicationTeam;
import discord4j.core.object.entity.Entity;
import discord4j.core.object.entity.User;
import discord4j.core.retriever.EntityRetrievalStrategy;
import discord4j.core.util.EntityUtil;
import discord4j.core.util.ImageUtil;
import discord4j.discordjson.json.ApplicationInfoData;
import discord4j.discordjson.json.ApplicationTeamData;
import discord4j.rest.util.Image;
import java.util.Objects;
import java.util.Optional;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public final class ApplicationInfo
implements Entity {
    private static final String ICON_IMAGE_PATH = "app-icons/%s/%s";
    private final GatewayDiscordClient gateway;
    private final ApplicationInfoData data;

    public ApplicationInfo(GatewayDiscordClient gateway, ApplicationInfoData data) {
        this.gateway = Objects.requireNonNull(gateway);
        this.data = Objects.requireNonNull(data);
    }

    @Override
    public GatewayDiscordClient getClient() {
        return this.gateway;
    }

    @Override
    public Snowflake getId() {
        return Snowflake.of(this.data.id());
    }

    public ApplicationInfoData getData() {
        return this.data;
    }

    public String getName() {
        return this.data.name();
    }

    public Optional<String> getIconUrl(Image.Format format) {
        return this.data.icon().map(icon -> ImageUtil.getUrl(String.format(ICON_IMAGE_PATH, this.getId().asString(), icon), format));
    }

    public Mono<Image> getIcon(Image.Format format) {
        return Mono.justOrEmpty(this.getIconUrl(format)).flatMap(Image::ofUrl);
    }

    public String getDescription() {
        return this.data.description();
    }

    public boolean isPublic() {
        return this.data.botPublic();
    }

    public boolean requireCodeGrant() {
        return this.data.botRequireCodeGrant();
    }

    public Optional<String> getTermsOfServiceUrl() {
        return this.data.termsOfServiceUrl().toOptional();
    }

    public Optional<String> getPrivacyPolicyUrl() {
        return this.data.privacyPolicyUrl().toOptional();
    }

    public Snowflake getOwnerId() {
        return Snowflake.of(this.data.owner().id());
    }

    public Mono<User> getOwner() {
        return this.gateway.getUserById(this.getOwnerId());
    }

    public Mono<User> getOwner(EntityRetrievalStrategy retrievalStrategy) {
        return this.gateway.withRetrievalStrategy(retrievalStrategy).getUserById(this.getOwnerId());
    }

    public Optional<ApplicationTeam> getTeam() {
        return this.data.team().map(data -> new ApplicationTeam(this.gateway, (ApplicationTeamData)data));
    }

    public boolean equals(@Nullable Object obj) {
        return EntityUtil.equals(this, obj);
    }

    public int hashCode() {
        return EntityUtil.hashCode(this);
    }

    public String toString() {
        return "ApplicationInfo{data=" + this.data + '}';
    }
}

