/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.shard;

import discord4j.core.shard.KeyStore;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class JdkKeyStore<K extends Comparable<K>>
implements KeyStore<K> {
    private final Map<Integer, Set<K>> keysByShard = new ConcurrentHashMap<Integer, Set<K>>();

    @Override
    public void add(int shardId, K key) {
        this.keySet(shardId).add(key);
    }

    @Override
    public void remove(int shardId, K key) {
        this.keySet(shardId).remove(key);
    }

    @Override
    public void clear(int shardId) {
        this.keySet(shardId).clear();
    }

    @Override
    public Set<K> keys(int shardId) {
        return Collections.unmodifiableSet(this.keySet(shardId));
    }

    private Set<K> keySet(int shardId) {
        return this.keysByShard.computeIfAbsent(shardId, k -> ConcurrentHashMap.newKeySet());
    }
}

