/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.shard;

import discord4j.core.shard.KeyStoreRegistry;
import discord4j.core.shard.ShardAwareStore;
import discord4j.store.api.Store;
import discord4j.store.api.primitive.ForwardingStore;
import discord4j.store.api.primitive.LongObjStore;
import discord4j.store.api.service.StoreService;
import discord4j.store.api.util.StoreContext;
import reactor.core.publisher.Mono;

public class ShardAwareStoreService
implements StoreService {
    private final KeyStoreRegistry registry;
    private final StoreService backingStoreService;

    public ShardAwareStoreService(KeyStoreRegistry registry, StoreService backingStoreService) {
        this.registry = registry;
        this.backingStoreService = backingStoreService;
    }

    @Override
    public boolean hasGenericStores() {
        return this.backingStoreService.hasGenericStores();
    }

    @Override
    public <K extends Comparable<K>, V> Store<K, V> provideGenericStore(Class<K> keyClass, Class<V> valueClass) {
        if (!this.registry.containsStore(valueClass)) {
            this.registry.putStore(valueClass, this.backingStoreService.provideGenericStore(keyClass, valueClass));
        }
        return new ShardAwareStore<K, V>(this.registry.getValueStore(keyClass, valueClass), this.registry.getKeyStore(valueClass));
    }

    @Override
    public boolean hasLongObjStores() {
        return true;
    }

    @Override
    public <V> LongObjStore<V> provideLongObjStore(Class<V> valueClass) {
        return new ForwardingStore<V>(this.provideGenericStore(Long.class, valueClass));
    }

    @Override
    public void init(StoreContext context) {
        this.backingStoreService.init(context);
    }

    @Override
    public Mono<Void> dispose() {
        return this.backingStoreService.dispose();
    }
}

