/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.common.util.Snowflake;
import discord4j.core.object.Region;
import discord4j.core.object.entity.Guild;
import discord4j.core.spec.AuditSpec;
import discord4j.discordjson.json.GuildModifyRequest;
import discord4j.discordjson.json.ImmutableGuildModifyRequest;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.Image;
import java.util.Arrays;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import reactor.util.annotation.Nullable;

public class GuildEditSpec
implements AuditSpec<GuildModifyRequest> {
    private final ImmutableGuildModifyRequest.Builder requestBuilder = GuildModifyRequest.builder();
    @Nullable
    private String reason;

    public GuildEditSpec setName(String name) {
        this.requestBuilder.name(name);
        return this;
    }

    public GuildEditSpec setRegion(Region.Id regionId) {
        this.requestBuilder.region(Possible.of(Optional.of(regionId).map(Region.Id::getValue)));
        return this;
    }

    public GuildEditSpec setRegion(@Nullable String regionId) {
        this.requestBuilder.region(Possible.of(Optional.ofNullable(regionId)));
        return this;
    }

    public GuildEditSpec setVerificationLevel(Guild.VerificationLevel verificationLevel) {
        this.requestBuilder.verificationLevel(verificationLevel.getValue());
        return this;
    }

    public GuildEditSpec setDefaultMessageNotificationsLevel(Guild.NotificationLevel notificationsLevel) {
        this.requestBuilder.defaultMessageNotifications(notificationsLevel.getValue());
        return this;
    }

    public GuildEditSpec setExplicitContentFilter(Guild.ContentFilterLevel level) {
        this.requestBuilder.explicitContentFilter(level.getValue());
        return this;
    }

    public GuildEditSpec setAfkChannelId(@Nullable Snowflake afkChannelId) {
        this.requestBuilder.afkChannelId(Possible.of(Optional.ofNullable(afkChannelId).map(Snowflake::asString)));
        return this;
    }

    public GuildEditSpec setAfkTimeout(int afkTimeout) {
        this.requestBuilder.afkTimeout(afkTimeout);
        return this;
    }

    public GuildEditSpec setIcon(@Nullable Image icon) {
        this.requestBuilder.icon(Possible.of(Optional.ofNullable(icon).map(Image::getDataUri)));
        return this;
    }

    public GuildEditSpec setOwnerId(Snowflake ownerId) {
        this.requestBuilder.ownerId(ownerId.asString());
        return this;
    }

    public GuildEditSpec setSplash(@Nullable Image splash) {
        this.requestBuilder.splash(Possible.of(Optional.ofNullable(splash).map(Image::getDataUri)));
        return this;
    }

    public GuildEditSpec setDiscoverySplash(@Nullable Image discoverySplash) {
        this.requestBuilder.splash(Possible.of(Optional.ofNullable(discoverySplash).map(Image::getDataUri)));
        return this;
    }

    public GuildEditSpec setBanner(@Nullable Image banner) {
        this.requestBuilder.banner(Possible.of(Optional.ofNullable(banner).map(Image::getDataUri)));
        return this;
    }

    public GuildEditSpec setSystemChannelId(@Nullable Snowflake systemChannelId) {
        this.requestBuilder.systemChannelId(Possible.of(Optional.ofNullable(systemChannelId).map(Snowflake::asString)));
        return this;
    }

    @Deprecated
    public GuildEditSpec setSystemChannelFlags(@Nullable Guild.SystemChannelFlag flag) {
        this.requestBuilder.systemChannelFlags(flag == null ? Possible.absent() : Possible.of(flag.getValue()));
        return this;
    }

    public GuildEditSpec setSystemChannelFlags(Guild.SystemChannelFlag ... flags) {
        if (flags != null) {
            this.requestBuilder.systemChannelFlags(Possible.of(Arrays.stream(flags).mapToInt(Guild.SystemChannelFlag::getValue).reduce(0, (left, right) -> left | right)));
        } else {
            this.requestBuilder.systemChannelFlags(Possible.absent());
        }
        return this;
    }

    public GuildEditSpec setRulesChannelId(@Nullable Snowflake rulesChannelId) {
        this.requestBuilder.rulesChannelId(Possible.of(Optional.ofNullable(rulesChannelId).map(Snowflake::asString)));
        return this;
    }

    public GuildEditSpec setPublicUpdatesChannelId(@Nullable Snowflake publicUpdatesChannelId) {
        this.requestBuilder.publicUpdatesChannelId(Possible.of(Optional.ofNullable(publicUpdatesChannelId).map(Snowflake::asString)));
        return this;
    }

    public GuildEditSpec setPreferredLocale(@Nullable Locale preferredLocale) {
        this.requestBuilder.preferredLocale(Possible.of(Optional.ofNullable(preferredLocale).map(Locale::toLanguageTag)));
        return this;
    }

    public GuildEditSpec setFeatures(Set<String> features) {
        this.requestBuilder.features(features);
        return this;
    }

    public GuildEditSpec setDescription(@Nullable String description) {
        this.requestBuilder.description(description);
        return this;
    }

    public GuildEditSpec setReason(@Nullable String reason) {
        this.reason = reason;
        return this;
    }

    @Override
    @Nullable
    public String getReason() {
        return this.reason;
    }

    @Override
    public GuildModifyRequest asRequest() {
        return this.requestBuilder.build();
    }
}

