/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.common.util.Snowflake;
import discord4j.core.object.component.LayoutComponent;
import discord4j.core.object.component.MessageComponent;
import discord4j.core.spec.EmbedCreateSpec;
import discord4j.core.spec.MessageReferenceSpec;
import discord4j.core.spec.Spec;
import discord4j.discordjson.json.AllowedMentionsData;
import discord4j.discordjson.json.EmbedData;
import discord4j.discordjson.json.ImmutableMessageCreateRequest;
import discord4j.discordjson.json.MessageCreateRequest;
import discord4j.discordjson.json.MessageReferenceData;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.AllowedMentions;
import discord4j.rest.util.MultipartRequest;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import reactor.util.annotation.Nullable;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

public class MessageCreateSpec
implements Spec<MultipartRequest> {
    @Nullable
    private String content;
    @Nullable
    private String nonce;
    private boolean tts;
    private List<EmbedData> embeds;
    private List<Tuple2<String, InputStream>> files;
    private AllowedMentionsData allowedMentionsData;
    private MessageReferenceData messageReferenceData;
    private List<LayoutComponent> components;

    public MessageCreateSpec setContent(String content) {
        this.content = content;
        return this;
    }

    public MessageCreateSpec setNonce(Snowflake nonce) {
        this.nonce = nonce.asString();
        return this;
    }

    public MessageCreateSpec setTts(boolean tts) {
        this.tts = tts;
        return this;
    }

    @Deprecated
    public MessageCreateSpec setEmbed(Consumer<? super EmbedCreateSpec> spec) {
        EmbedCreateSpec mutatedSpec = new EmbedCreateSpec();
        spec.accept(mutatedSpec);
        this.embeds = Collections.singletonList(mutatedSpec.asRequest());
        return this;
    }

    public MessageCreateSpec addEmbed(Consumer<? super EmbedCreateSpec> spec) {
        EmbedCreateSpec mutatedSpec = new EmbedCreateSpec();
        spec.accept(mutatedSpec);
        if (this.embeds == null) {
            this.embeds = new ArrayList<EmbedData>(1);
        }
        this.embeds.add(mutatedSpec.asRequest());
        return this;
    }

    public MessageCreateSpec addFile(String fileName, InputStream file) {
        if (this.files == null) {
            this.files = new ArrayList<Tuple2<String, InputStream>>(1);
        }
        this.files.add(Tuples.of(fileName, file));
        return this;
    }

    public MessageCreateSpec addFileSpoiler(String fileName, InputStream file) {
        return this.addFile("SPOILER_" + fileName, file);
    }

    public MessageCreateSpec setAllowedMentions(@Nullable AllowedMentions allowedMentions) {
        this.allowedMentionsData = allowedMentions != null ? allowedMentions.toData() : null;
        return this;
    }

    public MessageCreateSpec setMessageReference(Snowflake messageId) {
        MessageReferenceSpec spec = new MessageReferenceSpec();
        spec.setMessageId(messageId);
        this.messageReferenceData = spec.asRequest();
        return this;
    }

    public MessageCreateSpec setComponents(LayoutComponent ... components) {
        return this.setComponents(Arrays.asList(components));
    }

    public MessageCreateSpec setComponents(List<LayoutComponent> components) {
        this.components = components;
        return this;
    }

    @Override
    public MultipartRequest asRequest() {
        ImmutableMessageCreateRequest json = MessageCreateRequest.builder().content(this.content == null ? Possible.absent() : Possible.of(this.content)).nonce(this.nonce == null ? Possible.absent() : Possible.of(this.nonce)).tts(this.tts).embeds(this.embeds == null ? Possible.absent() : Possible.of(this.embeds)).allowedMentions(this.allowedMentionsData == null ? Possible.absent() : Possible.of(this.allowedMentionsData)).messageReference(this.messageReferenceData == null ? Possible.absent() : Possible.of(this.messageReferenceData)).components(this.components == null ? Possible.absent() : Possible.of(this.components.stream().map(MessageComponent::getData).collect(Collectors.toList()))).build();
        return new MultipartRequest(json, this.files == null ? Collections.emptyList() : this.files);
    }
}

