/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.util;

import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.entity.Entity;
import discord4j.core.object.entity.channel.Category;
import discord4j.core.object.entity.channel.Channel;
import discord4j.core.object.entity.channel.NewsChannel;
import discord4j.core.object.entity.channel.PrivateChannel;
import discord4j.core.object.entity.channel.StoreChannel;
import discord4j.core.object.entity.channel.TextChannel;
import discord4j.core.object.entity.channel.VoiceChannel;
import discord4j.core.object.reaction.ReactionEmoji;
import discord4j.discordjson.json.ChannelData;
import reactor.util.annotation.Nullable;

public final class EntityUtil {
    @Deprecated
    public static final long DISCORD_EPOCH = 1420070400000L;

    public static String getEmojiString(ReactionEmoji emoji) {
        if (emoji instanceof ReactionEmoji.Unicode) {
            return ((ReactionEmoji.Unicode)emoji).getRaw();
        }
        ReactionEmoji.Custom custom = (ReactionEmoji.Custom)emoji;
        return custom.getName() + ":" + custom.getId().asString();
    }

    public static Channel getChannel(GatewayDiscordClient gateway, ChannelData data) {
        switch (Channel.Type.of(data.type())) {
            case GUILD_TEXT: {
                return new TextChannel(gateway, data);
            }
            case DM: {
                return new PrivateChannel(gateway, data);
            }
            case GUILD_VOICE: 
            case GUILD_STAGE_VOICE: {
                return new VoiceChannel(gateway, data);
            }
            case GUILD_CATEGORY: {
                return new Category(gateway, data);
            }
            case GUILD_NEWS: {
                return new NewsChannel(gateway, data);
            }
            case GUILD_STORE: {
                return new StoreChannel(gateway, data);
            }
        }
        return (Channel)EntityUtil.throwUnsupportedDiscordValue(data);
    }

    public static <T> T throwUnsupportedDiscordValue(Object value) {
        throw new UnsupportedOperationException("Unknown Value: " + value);
    }

    public static boolean equals(Entity entity, @Nullable Object obj) {
        return entity.getClass().isInstance(obj) && ((Entity)obj).getId().equals(entity.getId());
    }

    public static int hashCode(Entity entity) {
        return entity.getId().hashCode();
    }

    private EntityUtil() {
    }
}

