/*
 * Decompiled with CFR 0.152.
 */
package discord4j.gateway.retry;

import discord4j.common.close.CloseException;
import discord4j.common.retry.ReconnectContext;
import discord4j.common.retry.ReconnectOptions;
import discord4j.gateway.GatewayConnection;
import discord4j.gateway.retry.GatewayRetrySignal;
import discord4j.gateway.retry.InvalidSessionException;
import discord4j.gateway.retry.PartialDisconnectException;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;
import reactor.util.retry.Retry;

public class GatewayRetrySpec
extends Retry {
    public static final List<Integer> NON_RETRYABLE_STATUS_CODES = Arrays.asList(4004, 4010, 4011, 4012, 4013, 4014);
    private static final Consumer<GatewayRetrySignal> NO_OP_CONSUMER = retrySignal -> {};
    private final ReconnectOptions reconnectOptions;
    private final ReconnectContext reconnectContext;
    private final Consumer<GatewayRetrySignal> doPreRetry;

    GatewayRetrySpec(ReconnectOptions reconnectOptions, ReconnectContext reconnectContext, Consumer<GatewayRetrySignal> doPreRetry) {
        this.reconnectOptions = reconnectOptions;
        this.reconnectContext = reconnectContext;
        this.doPreRetry = doPreRetry;
    }

    public static GatewayRetrySpec create(ReconnectOptions reconnectOptions, ReconnectContext reconnectContext) {
        return new GatewayRetrySpec(reconnectOptions, reconnectContext, NO_OP_CONSUMER);
    }

    public GatewayRetrySpec doBeforeRetry(Consumer<GatewayRetrySignal> doBeforeRetry) {
        return new GatewayRetrySpec(this.reconnectOptions, this.reconnectContext, this.doPreRetry.andThen(doBeforeRetry));
    }

    private boolean isRetryable(@Nullable Throwable t) {
        if (t instanceof CloseException) {
            CloseException closeException = (CloseException)t;
            return !NON_RETRYABLE_STATUS_CODES.contains(closeException.getCode());
        }
        return !(t instanceof PartialDisconnectException);
    }

    private boolean canResume(Throwable t) {
        if (t instanceof CloseException) {
            CloseException closeException = (CloseException)t;
            return closeException.getCode() < 4000;
        }
        return !(t instanceof InvalidSessionException);
    }

    public Flux<Long> generateCompanion(Flux<Retry.RetrySignal> t) {
        return t.concatMap(retryWhenState -> {
            GatewayConnection.State nextState;
            Duration nextBackoff;
            long iteration;
            Retry.RetrySignal copy = retryWhenState.copy();
            Throwable currentFailure = copy.failure();
            if (currentFailure == null) {
                return Mono.error(new IllegalStateException("Retry.RetrySignal#failure() not expected to be null"));
            }
            if (!this.isRetryable(currentFailure)) {
                return Mono.error(currentFailure);
            }
            if (currentFailure instanceof InvalidSessionException) {
                this.reconnectContext.reset();
            }
            if ((iteration = (long)this.reconnectContext.getAttempts()) >= this.reconnectOptions.getMaxRetries()) {
                return Mono.error(Exceptions.retryExhausted("Retries exhausted: " + iteration + "/" + this.reconnectOptions.getMaxRetries(), copy.failure()));
            }
            Duration minBackoff = this.reconnectOptions.getFirstBackoff();
            Duration maxBackoff = this.reconnectOptions.getMaxBackoffInterval();
            if (this.canResume(currentFailure)) {
                nextBackoff = iteration == 1L ? Duration.ZERO : GatewayRetrySpec.computeBackoff(iteration - 2L, minBackoff, maxBackoff);
                nextState = GatewayConnection.State.RESUMING;
            } else {
                nextBackoff = GatewayRetrySpec.computeBackoff(iteration - 1L, minBackoff, maxBackoff);
                nextState = GatewayConnection.State.RECONNECTING;
            }
            this.reconnectContext.next();
            if (nextBackoff.isZero()) {
                return GatewayRetrySpec.applyHooks(new GatewayRetrySignal(copy.failure(), iteration, nextBackoff, nextState), Mono.just(iteration), this.doPreRetry);
            }
            Duration effectiveBackoff = nextBackoff.plusMillis(GatewayRetrySpec.computeJitter(nextBackoff, minBackoff, maxBackoff, this.reconnectOptions.getJitterFactor()));
            return GatewayRetrySpec.applyHooks(new GatewayRetrySignal(copy.failure(), iteration, effectiveBackoff, nextState), Mono.delay(effectiveBackoff, this.reconnectOptions.getBackoffScheduler()), this.doPreRetry);
        });
    }

    static long computeJitter(Duration nextBackoff, Duration minBackoff, Duration maxBackoff, double factor) {
        long jitterOffset;
        ThreadLocalRandom random = ThreadLocalRandom.current();
        try {
            jitterOffset = nextBackoff.multipliedBy((long)(100.0 * factor)).dividedBy(100L).toMillis();
        }
        catch (ArithmeticException ae) {
            jitterOffset = Math.round(9.223372036854776E18 * factor);
        }
        long lowBound = Math.max(minBackoff.minus(nextBackoff).toMillis(), -jitterOffset);
        long highBound = Math.min(maxBackoff.minus(nextBackoff).toMillis(), jitterOffset);
        if (highBound == lowBound) {
            if (highBound == 0L) {
                return 0L;
            }
            return random.nextLong(highBound);
        }
        return random.nextLong(lowBound, highBound);
    }

    static Duration computeBackoff(long iteration, Duration minBackoff, Duration maxBackoff) {
        Duration nextBackoff;
        try {
            nextBackoff = minBackoff.multipliedBy((long)Math.pow(2.0, iteration));
            if (nextBackoff.compareTo(maxBackoff) > 0) {
                nextBackoff = maxBackoff;
            }
        }
        catch (ArithmeticException overflow) {
            nextBackoff = maxBackoff;
        }
        return nextBackoff;
    }

    static <T> Mono<T> applyHooks(GatewayRetrySignal retrySignal, Mono<T> originalCompanion, Consumer<GatewayRetrySignal> doPreRetry) {
        if (doPreRetry != NO_OP_CONSUMER) {
            try {
                doPreRetry.accept(retrySignal);
            }
            catch (Throwable e) {
                return Mono.error(e);
            }
        }
        return originalCompanion;
    }
}

