/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.util;

import discord4j.common.ReactorResources;
import java.util.Arrays;
import java.util.Base64;
import java.util.Objects;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;
import reactor.util.annotation.Nullable;

public final class Image {
    private final byte[] data;
    private final Format format;

    public static Image ofRaw(byte[] data, Format format) {
        return new Image(data, format);
    }

    public static Mono<Image> ofUrl(String url) {
        return ((HttpClient.ResponseReceiver)ReactorResources.DEFAULT_HTTP_CLIENT.get().get().uri(url)).responseSingle((res, body) -> body.asByteArray().map(image -> {
            Format format = Format.fromContentType(res.responseHeaders().get("Content-Type"));
            return Image.ofRaw(image, format);
        }));
    }

    private Image(byte[] data, Format format) {
        this.data = data;
        this.format = format;
    }

    public byte[] getData() {
        return this.data;
    }

    public Format getFormat() {
        return this.format;
    }

    public String getHash() {
        return Base64.getEncoder().encodeToString(this.data);
    }

    public String getDataUri() {
        return String.format("data:image/%s;base64,%s", this.format.extension, this.getHash());
    }

    public String toString() {
        return "Image{data=" + Arrays.toString(this.data) + ", format=" + (Object)((Object)this.format) + '}';
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Image image = (Image)o;
        return Arrays.equals(this.data, image.data) && this.format == image.format;
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.format});
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }

    public static enum Format {
        UNKNOWN("UNKNOWN"),
        JPEG("jpeg"),
        PNG("png"),
        WEB_P("webp"),
        GIF("gif");

        private final String extension;

        private Format(String extension) {
            this.extension = extension;
        }

        public String getExtension() {
            return this.extension;
        }

        private static Format fromContentType(String contentType) {
            switch (contentType) {
                case "image/jpeg": {
                    return JPEG;
                }
                case "image/png": {
                    return PNG;
                }
                case "image/webp": {
                    return WEB_P;
                }
                case "image/gif": {
                    return GIF;
                }
            }
            return UNKNOWN;
        }
    }
}

