/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientConfiguration;
import reactor.netty.http.client.HttpClientOperator;
import reactor.netty.tcp.TcpClient;

final class HttpClientHeadersWhen
extends HttpClientOperator
implements Function<Bootstrap, Bootstrap> {
    final Function<? super HttpHeaders, Mono<? extends HttpHeaders>> headers;

    HttpClientHeadersWhen(HttpClient client, Function<? super HttpHeaders, Mono<? extends HttpHeaders>> headers) {
        super(client);
        this.headers = Objects.requireNonNull(headers, "headers");
    }

    @Override
    protected TcpClient tcpConfiguration() {
        return this.source.tcpConfiguration().bootstrap(this);
    }

    @Override
    public Bootstrap apply(Bootstrap bootstrap) {
        HttpClientConfiguration.deferredConf(bootstrap, conf -> this.headers.apply(HttpClientHeadersWhen.getOrCreate(conf.headers)).map(conf::headers));
        return bootstrap;
    }

    static HttpHeaders getOrCreate(@Nullable HttpHeaders h) {
        if (h == null) {
            return new DefaultHttpHeaders();
        }
        return h;
    }
}

