/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.filter;

import com.sedmelluq.discord.lavaplayer.filter.FloatPcmAudioFilter;
import com.sedmelluq.discord.lavaplayer.natives.samplerate.SampleRateConverter;
import com.sedmelluq.discord.lavaplayer.player.AudioConfiguration;

public class ResamplingPcmAudioFilter
implements FloatPcmAudioFilter {
    private static final int BUFFER_SIZE = 4096;
    private final FloatPcmAudioFilter downstream;
    private final SampleRateConverter[] converters;
    private final SampleRateConverter.Progress progress = new SampleRateConverter.Progress();
    private final float[][] outputSegments;

    public ResamplingPcmAudioFilter(AudioConfiguration configuration, int channels, FloatPcmAudioFilter downstream, int sourceRate, int targetRate) {
        this.downstream = downstream;
        this.converters = new SampleRateConverter[channels];
        this.outputSegments = new float[channels][];
        SampleRateConverter.ResamplingType type = ResamplingPcmAudioFilter.getResamplingType(configuration.getResamplingQuality());
        for (int i = 0; i < channels; ++i) {
            this.outputSegments[i] = new float[4096];
            this.converters[i] = new SampleRateConverter(type, 1, sourceRate, targetRate);
        }
    }

    @Override
    public void seekPerformed(long requestedTime, long providedTime) {
        for (SampleRateConverter converter : this.converters) {
            converter.reset();
        }
    }

    @Override
    public void flush() throws InterruptedException {
    }

    @Override
    public void close() {
        for (SampleRateConverter converter : this.converters) {
            converter.close();
        }
    }

    @Override
    public void process(float[][] input, int offset, int length) throws InterruptedException {
        do {
            for (int i = 0; i < input.length; ++i) {
                this.converters[i].process(input[i], offset, length, this.outputSegments[i], 0, 4096, false, this.progress);
            }
            offset += this.progress.getInputUsed();
            length -= this.progress.getInputUsed();
            if (this.progress.getOutputGenerated() <= 0) continue;
            this.downstream.process(this.outputSegments, 0, this.progress.getOutputGenerated());
        } while (length > 0 || this.progress.getOutputGenerated() == 4096);
    }

    private static SampleRateConverter.ResamplingType getResamplingType(AudioConfiguration.ResamplingQuality quality) {
        switch (quality) {
            case HIGHEST: {
                return SampleRateConverter.ResamplingType.SINC_BEST_QUALITY;
            }
            case HIGH: {
                return SampleRateConverter.ResamplingType.SINC_MEDIUM_QUALITY;
            }
            case MEDIUM: {
                return SampleRateConverter.ResamplingType.SINC_FASTEST;
            }
        }
        return SampleRateConverter.ResamplingType.LINEAR;
    }
}

