/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.format.transcoder;

import com.sedmelluq.discord.lavaplayer.format.AudioDataFormat;
import com.sedmelluq.discord.lavaplayer.format.transcoder.AudioChunkDecoder;
import com.sedmelluq.discord.lavaplayer.natives.opus.OpusDecoder;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;

public class OpusChunkDecoder
implements AudioChunkDecoder {
    private final OpusDecoder decoder;
    private final ByteBuffer encodedBuffer = ByteBuffer.allocateDirect(4096);

    public OpusChunkDecoder(AudioDataFormat format) {
        this.decoder = new OpusDecoder(format.sampleRate, format.channelCount);
    }

    @Override
    public void decode(byte[] encoded, ShortBuffer buffer) {
        this.decodeWithCount(encoded, buffer);
    }

    public int decodeWithCount(byte[] encoded, ShortBuffer buffer) {
        this.encodedBuffer.clear();
        this.encodedBuffer.put(encoded);
        this.encodedBuffer.flip();
        buffer.clear();
        return this.decoder.decode(this.encodedBuffer, buffer);
    }

    @Override
    public void decode(ByteBuffer encoded, ShortBuffer buffer) {
        this.decoder.decode(encoded, buffer);
    }

    @Override
    public void close() {
        this.decoder.close();
    }
}

