/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.source.nico;

import com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.source.AudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.nico.NicoAudioTrack;
import com.sedmelluq.discord.lavaplayer.tools.DataFormatTools;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpConfigurable;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterfaceManager;
import com.sedmelluq.discord.lavaplayer.track.AudioItem;
import com.sedmelluq.discord.lavaplayer.track.AudioReference;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.Header;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public class NicoAudioSourceManager
implements AudioSourceManager,
HttpConfigurable {
    private static final String TRACK_URL_REGEX = "^(?:http://|https://|)(?:www\\.|)nicovideo\\.jp/watch/(.{2}[0-9]+)(?:\\?.*|)$";
    private static final Pattern trackUrlPattern = Pattern.compile("^(?:http://|https://|)(?:www\\.|)nicovideo\\.jp/watch/(.{2}[0-9]+)(?:\\?.*|)$");
    private final HttpInterfaceManager httpInterfaceManager = HttpClientTools.createDefaultThreadLocalManager();
    private final AtomicBoolean loggedIn = new AtomicBoolean();

    public NicoAudioSourceManager() {
        this(null, null);
    }

    public NicoAudioSourceManager(String email, String password) {
        if (!DataFormatTools.isNullOrEmpty(email) && !DataFormatTools.isNullOrEmpty(password)) {
            this.login(email, password);
        }
    }

    @Override
    public String getSourceName() {
        return "niconico";
    }

    @Override
    public AudioItem loadItem(AudioPlayerManager manager, AudioReference reference) {
        Matcher trackMatcher = trackUrlPattern.matcher(reference.identifier);
        if (trackMatcher.matches()) {
            return this.loadTrack(trackMatcher.group(1));
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private AudioTrack loadTrack(String videoId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private AudioTrack extractTrackFromXml(String videoId, Document document) {
        Iterator iterator = document.select(":root > thumb").iterator();
        if (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            String uploader = element.selectFirst("user_nickname").text();
            String title = element.selectFirst("title").text();
            long duration = DataFormatTools.durationTextToMillis(element.selectFirst("length").text());
            return new NicoAudioTrack(new AudioTrackInfo(title, uploader, duration, videoId, false, NicoAudioSourceManager.getWatchUrl(videoId)), this);
        }
        return null;
    }

    @Override
    public boolean isTrackEncodable(AudioTrack track) {
        return true;
    }

    @Override
    public void encodeTrack(AudioTrack track, DataOutput output) throws IOException {
    }

    @Override
    public AudioTrack decodeTrack(AudioTrackInfo trackInfo, DataInput input) throws IOException {
        return new NicoAudioTrack(trackInfo, this);
    }

    @Override
    public void shutdown() {
    }

    public HttpInterface getHttpInterface() {
        return this.httpInterfaceManager.getInterface();
    }

    @Override
    public void configureRequests(Function<RequestConfig, RequestConfig> configurator) {
        this.httpInterfaceManager.configureRequests(configurator);
    }

    @Override
    public void configureBuilder(Consumer<HttpClientBuilder> configurator) {
        this.httpInterfaceManager.configureBuilder(configurator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void login(String email, String password) {
        AtomicBoolean atomicBoolean = this.loggedIn;
        synchronized (atomicBoolean) {
            if (this.loggedIn.get()) {
                return;
            }
            HttpPost loginRequest = new HttpPost("https://secure.nicovideo.jp/secure/login");
            loginRequest.setEntity(new UrlEncodedFormEntity(Arrays.asList(new BasicNameValuePair("mail", email), new BasicNameValuePair("password", password)), StandardCharsets.UTF_8));
            try (HttpInterface httpInterface = this.getHttpInterface();
                 CloseableHttpResponse response = httpInterface.execute(loginRequest);){
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode != 302) {
                    throw new IOException("Unexpected response code " + statusCode);
                }
                Header location = response.getFirstHeader("Location");
                if (location == null || location.getValue().contains("message=")) {
                    throw new FriendlyException("Login details for NicoNico are invalid.", FriendlyException.Severity.COMMON, null);
                }
                this.loggedIn.set(true);
            }
            catch (IOException e) {
                throw new FriendlyException("Exception when trying to log into NicoNico", FriendlyException.Severity.SUSPICIOUS, e);
            }
        }
    }

    private static String getWatchUrl(String videoId) {
        return "http://www.nicovideo.jp/watch/" + videoId;
    }
}

